/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.api.domain.um;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.adorsys.ledgers.middleware.api.domain.um.AisAccountAccessInfoTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;

@ApiModel(description="Ais consent request", value="AisConsentRequest")
public class AisConsentTO {
    @ApiModelProperty(value="The consent id", required=true)
    private String id;
    @ApiModelProperty(value="Corresponding PSU", required=true)
    private String userId;
    @ApiModelProperty(value="ID of the corresponding TPP.", required=true, example="testTPP")
    private String tppId;
    @ApiModelProperty(value="Maximum frequency for an access per day. For a once-off access, this attribute is set to 1", required=true, example="4")
    private int frequencyPerDay;
    @ApiModelProperty(value="Set of accesses given by psu for this account", required=true)
    private AisAccountAccessInfoTO access;
    @ApiModelProperty(value="Consent`s expiration date. The content is the local ASPSP date in ISODate Format", required=true, example="2020-10-10")
    private LocalDate validUntil;
    @ApiModelProperty(value="'true', if the consent is for recurring access to the account data , 'false', if the consent is for one access to the account data", required=true, example="false")
    private boolean recurringIndicator;

    @JsonIgnore
    public boolean isValidConsent() {
        return this.validUntil == null || this.validUntil.isAfter(LocalDate.now());
    }

    public String getId() {
        return this.id;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getTppId() {
        return this.tppId;
    }

    public int getFrequencyPerDay() {
        return this.frequencyPerDay;
    }

    public AisAccountAccessInfoTO getAccess() {
        return this.access;
    }

    public LocalDate getValidUntil() {
        return this.validUntil;
    }

    public boolean isRecurringIndicator() {
        return this.recurringIndicator;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setTppId(String tppId) {
        this.tppId = tppId;
    }

    public void setFrequencyPerDay(int frequencyPerDay) {
        this.frequencyPerDay = frequencyPerDay;
    }

    public void setAccess(AisAccountAccessInfoTO access) {
        this.access = access;
    }

    public void setValidUntil(LocalDate validUntil) {
        this.validUntil = validUntil;
    }

    public void setRecurringIndicator(boolean recurringIndicator) {
        this.recurringIndicator = recurringIndicator;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AisConsentTO)) {
            return false;
        }
        AisConsentTO other = (AisConsentTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$tppId = this.getTppId();
        String other$tppId = other.getTppId();
        if (this$tppId == null ? other$tppId != null : !this$tppId.equals(other$tppId)) {
            return false;
        }
        if (this.getFrequencyPerDay() != other.getFrequencyPerDay()) {
            return false;
        }
        AisAccountAccessInfoTO this$access = this.getAccess();
        AisAccountAccessInfoTO other$access = other.getAccess();
        if (this$access == null ? other$access != null : !((Object)this$access).equals(other$access)) {
            return false;
        }
        LocalDate this$validUntil = this.getValidUntil();
        LocalDate other$validUntil = other.getValidUntil();
        if (this$validUntil == null ? other$validUntil != null : !((Object)this$validUntil).equals(other$validUntil)) {
            return false;
        }
        return this.isRecurringIndicator() == other.isRecurringIndicator();
    }

    protected boolean canEqual(Object other) {
        return other instanceof AisConsentTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $tppId = this.getTppId();
        result = result * 59 + ($tppId == null ? 43 : $tppId.hashCode());
        result = result * 59 + this.getFrequencyPerDay();
        AisAccountAccessInfoTO $access = this.getAccess();
        result = result * 59 + ($access == null ? 43 : ((Object)$access).hashCode());
        LocalDate $validUntil = this.getValidUntil();
        result = result * 59 + ($validUntil == null ? 43 : ((Object)$validUntil).hashCode());
        result = result * 59 + (this.isRecurringIndicator() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "AisConsentTO(id=" + this.getId() + ", userId=" + this.getUserId() + ", tppId=" + this.getTppId() + ", frequencyPerDay=" + this.getFrequencyPerDay() + ", access=" + this.getAccess() + ", validUntil=" + this.getValidUntil() + ", recurringIndicator=" + this.isRecurringIndicator() + ")";
    }

    public AisConsentTO() {
    }

    public AisConsentTO(String id, String userId, String tppId, int frequencyPerDay, AisAccountAccessInfoTO access, LocalDate validUntil, boolean recurringIndicator) {
        this.id = id;
        this.userId = userId;
        this.tppId = tppId;
        this.frequencyPerDay = frequencyPerDay;
        this.access = access;
        this.validUntil = validUntil;
        this.recurringIndicator = recurringIndicator;
    }
}

