/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.api.domain.um;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.adorsys.ledgers.middleware.api.domain.um.AccessTypeTO;
import java.util.Currency;
import java.util.EnumSet;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class AccountAccessTO {
    private String id;
    @NotNull
    private String iban;
    @NotNull
    private Currency currency;
    @NotNull
    private AccessTypeTO accessType;
    @NotNull
    private int scaWeight;
    @NotNull
    private String accountId;

    @JsonIgnore
    public boolean hasPaymentAccess(String requestedIban) {
        return this.hasIban(requestedIban) && EnumSet.of(AccessTypeTO.OWNER, AccessTypeTO.DISPOSE).contains((Object)this.accessType);
    }

    @JsonIgnore
    public boolean hasIban(String requestedIban) {
        return StringUtils.equalsIgnoreCase((CharSequence)requestedIban, (CharSequence)this.iban);
    }

    public String getId() {
        return this.id;
    }

    public String getIban() {
        return this.iban;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public AccessTypeTO getAccessType() {
        return this.accessType;
    }

    public int getScaWeight() {
        return this.scaWeight;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setIban(String iban) {
        this.iban = iban;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public void setAccessType(AccessTypeTO accessType) {
        this.accessType = accessType;
    }

    public void setScaWeight(int scaWeight) {
        this.scaWeight = scaWeight;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccountAccessTO)) {
            return false;
        }
        AccountAccessTO other = (AccountAccessTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$iban = this.getIban();
        String other$iban = other.getIban();
        if (this$iban == null ? other$iban != null : !this$iban.equals(other$iban)) {
            return false;
        }
        Currency this$currency = this.getCurrency();
        Currency other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        AccessTypeTO this$accessType = this.getAccessType();
        AccessTypeTO other$accessType = other.getAccessType();
        if (this$accessType == null ? other$accessType != null : !((Object)((Object)this$accessType)).equals((Object)other$accessType)) {
            return false;
        }
        if (this.getScaWeight() != other.getScaWeight()) {
            return false;
        }
        String this$accountId = this.getAccountId();
        String other$accountId = other.getAccountId();
        return !(this$accountId == null ? other$accountId != null : !this$accountId.equals(other$accountId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AccountAccessTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $iban = this.getIban();
        result = result * 59 + ($iban == null ? 43 : $iban.hashCode());
        Currency $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        AccessTypeTO $accessType = this.getAccessType();
        result = result * 59 + ($accessType == null ? 43 : ((Object)((Object)$accessType)).hashCode());
        result = result * 59 + this.getScaWeight();
        String $accountId = this.getAccountId();
        result = result * 59 + ($accountId == null ? 43 : $accountId.hashCode());
        return result;
    }

    public String toString() {
        return "AccountAccessTO(id=" + this.getId() + ", iban=" + this.getIban() + ", currency=" + this.getCurrency() + ", accessType=" + (Object)((Object)this.getAccessType()) + ", scaWeight=" + this.getScaWeight() + ", accountId=" + this.getAccountId() + ")";
    }

    public AccountAccessTO() {
    }

    public AccountAccessTO(String id, String iban, Currency currency, AccessTypeTO accessType, int scaWeight, String accountId) {
        this.id = id;
        this.iban = iban;
        this.currency = currency;
        this.accessType = accessType;
        this.scaWeight = scaWeight;
        this.accountId = accountId;
    }
}

