/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.api.domain.um;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class LoginKeyDataTO {
    private static final String V_00 = "V00";
    private static final int VERSION_STRING_LENGTH = 3;
    private static final String FORMAT_V00 = "yyyyMMddHHmmss";
    private static final DateTimeFormatter storage_formatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    private static final DateTimeFormatter display_formatter = DateTimeFormatter.ofPattern("dd LLLL yyyy");
    private static String current_version;
    private static final Map<String, String> formatMap;
    private final String userId;
    private final LocalDateTime loginTime;

    public LoginKeyDataTO(String userId, LocalDateTime time) {
        this.userId = userId;
        this.loginTime = time;
    }

    public String messageTemplate() {
        if (this.userId == null) {
            throw new IllegalStateException("Not expecting userId to be null.");
        }
        return String.format("Login process started at %s for %s", this.loginTime.format(display_formatter), this.userId);
    }

    public String toOpId() {
        if (current_version.length() != 3) {
            throw new IllegalStateException(String.format("Version string must be of length %s and shall never change.", current_version.length()));
        }
        return current_version + this.loginTime.format(storage_formatter) + this.userId;
    }

    public static LoginKeyDataTO fromOpId(String opId) {
        String version = StringUtils.substring((String)opId, (int)0, (int)3);
        String format = formatMap.get(version);
        if (format == null) {
            throw new IllegalStateException(String.format("Missing format with version number %s", version));
        }
        String loginDate = StringUtils.substring((String)opId, (int)3, (int)(3 + format.length()));
        String userId = StringUtils.substringAfter((String)opId, (String)loginDate);
        return new LoginKeyDataTO(userId, LocalDateTime.parse(loginDate, storage_formatter));
    }

    private LoginKeyDataTO() {
        this.userId = null;
        this.loginTime = null;
    }

    public String getUserId() {
        return this.userId;
    }

    public LocalDateTime getLoginTime() {
        return this.loginTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LoginKeyDataTO)) {
            return false;
        }
        LoginKeyDataTO other = (LoginKeyDataTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        LocalDateTime this$loginTime = this.getLoginTime();
        LocalDateTime other$loginTime = other.getLoginTime();
        return !(this$loginTime == null ? other$loginTime != null : !((Object)this$loginTime).equals(other$loginTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LoginKeyDataTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        LocalDateTime $loginTime = this.getLoginTime();
        result = result * 59 + ($loginTime == null ? 43 : ((Object)$loginTime).hashCode());
        return result;
    }

    public String toString() {
        return "LoginKeyDataTO(userId=" + this.getUserId() + ", loginTime=" + this.getLoginTime() + ")";
    }

    static {
        formatMap = new HashMap<String, String>();
        formatMap.put(V_00, FORMAT_V00);
        current_version = V_00;
    }
}

