/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.api.domain.um;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import de.adorsys.ledgers.middleware.api.domain.um.AisAccountAccessTypeTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
@ApiModel(description="Ais account access information", value="AisAccountAccessInfo")
public class AisAccountAccessInfoTO {
    @ApiModelProperty(value="Access to accounts")
    private List<String> accounts;
    @ApiModelProperty(value="Access to balances")
    private List<String> balances;
    @ApiModelProperty(value="Access to transactions")
    private List<String> transactions;
    @ApiModelProperty(value="Consent on all available accounts of psu", example="ALL_ACCOUNTS")
    private AisAccountAccessTypeTO availableAccounts;
    @ApiModelProperty(value="Consent on all accounts, balances and transactions of psu", example="ALL_ACCOUNTS")
    private AisAccountAccessTypeTO allPsd2;

    public boolean hasIbanInAccess(String iban) {
        return this.availableAccounts != null || this.allPsd2 != null || this.accounts != null && this.accounts.contains(iban) || this.balances != null && this.balances.contains(iban) || this.transactions != null && this.transactions.contains(iban);
    }

    public List<String> getAccounts() {
        return this.accounts;
    }

    public List<String> getBalances() {
        return this.balances;
    }

    public List<String> getTransactions() {
        return this.transactions;
    }

    public AisAccountAccessTypeTO getAvailableAccounts() {
        return this.availableAccounts;
    }

    public AisAccountAccessTypeTO getAllPsd2() {
        return this.allPsd2;
    }

    public void setAccounts(List<String> accounts) {
        this.accounts = accounts;
    }

    public void setBalances(List<String> balances) {
        this.balances = balances;
    }

    public void setTransactions(List<String> transactions) {
        this.transactions = transactions;
    }

    public void setAvailableAccounts(AisAccountAccessTypeTO availableAccounts) {
        this.availableAccounts = availableAccounts;
    }

    public void setAllPsd2(AisAccountAccessTypeTO allPsd2) {
        this.allPsd2 = allPsd2;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AisAccountAccessInfoTO)) {
            return false;
        }
        AisAccountAccessInfoTO other = (AisAccountAccessInfoTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$accounts = this.getAccounts();
        List<String> other$accounts = other.getAccounts();
        if (this$accounts == null ? other$accounts != null : !((Object)this$accounts).equals(other$accounts)) {
            return false;
        }
        List<String> this$balances = this.getBalances();
        List<String> other$balances = other.getBalances();
        if (this$balances == null ? other$balances != null : !((Object)this$balances).equals(other$balances)) {
            return false;
        }
        List<String> this$transactions = this.getTransactions();
        List<String> other$transactions = other.getTransactions();
        if (this$transactions == null ? other$transactions != null : !((Object)this$transactions).equals(other$transactions)) {
            return false;
        }
        AisAccountAccessTypeTO this$availableAccounts = this.getAvailableAccounts();
        AisAccountAccessTypeTO other$availableAccounts = other.getAvailableAccounts();
        if (this$availableAccounts == null ? other$availableAccounts != null : !((Object)((Object)this$availableAccounts)).equals((Object)other$availableAccounts)) {
            return false;
        }
        AisAccountAccessTypeTO this$allPsd2 = this.getAllPsd2();
        AisAccountAccessTypeTO other$allPsd2 = other.getAllPsd2();
        return !(this$allPsd2 == null ? other$allPsd2 != null : !((Object)((Object)this$allPsd2)).equals((Object)other$allPsd2));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AisAccountAccessInfoTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $accounts = this.getAccounts();
        result = result * 59 + ($accounts == null ? 43 : ((Object)$accounts).hashCode());
        List<String> $balances = this.getBalances();
        result = result * 59 + ($balances == null ? 43 : ((Object)$balances).hashCode());
        List<String> $transactions = this.getTransactions();
        result = result * 59 + ($transactions == null ? 43 : ((Object)$transactions).hashCode());
        AisAccountAccessTypeTO $availableAccounts = this.getAvailableAccounts();
        result = result * 59 + ($availableAccounts == null ? 43 : ((Object)((Object)$availableAccounts)).hashCode());
        AisAccountAccessTypeTO $allPsd2 = this.getAllPsd2();
        result = result * 59 + ($allPsd2 == null ? 43 : ((Object)((Object)$allPsd2)).hashCode());
        return result;
    }

    public String toString() {
        return "AisAccountAccessInfoTO(accounts=" + this.getAccounts() + ", balances=" + this.getBalances() + ", transactions=" + this.getTransactions() + ", availableAccounts=" + (Object)((Object)this.getAvailableAccounts()) + ", allPsd2=" + (Object)((Object)this.getAllPsd2()) + ")";
    }

    public AisAccountAccessInfoTO() {
    }

    public AisAccountAccessInfoTO(List<String> accounts, List<String> balances, List<String> transactions, AisAccountAccessTypeTO availableAccounts, AisAccountAccessTypeTO allPsd2) {
        this.accounts = accounts;
        this.balances = balances;
        this.transactions = transactions;
        this.availableAccounts = availableAccounts;
        this.allPsd2 = allPsd2;
    }
}

