/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.api.domain.um;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.adorsys.ledgers.middleware.api.domain.um.AccessTypeTO;
import java.util.EnumSet;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class AccountAccessTO {
    private String id;
    @NotNull
    private String iban;
    @NotNull
    private AccessTypeTO accessType;
    @NotNull
    private int scaWeight;

    @JsonIgnore
    public boolean hasPaymentAccess(String requestedIban) {
        return this.hasIban(requestedIban) && EnumSet.of(AccessTypeTO.OWNER, AccessTypeTO.DISPOSE).contains((Object)this.accessType);
    }

    @JsonIgnore
    public boolean hasIban(String requestedIban) {
        return StringUtils.equalsIgnoreCase((CharSequence)requestedIban, (CharSequence)this.iban);
    }

    public String getId() {
        return this.id;
    }

    public String getIban() {
        return this.iban;
    }

    public AccessTypeTO getAccessType() {
        return this.accessType;
    }

    public int getScaWeight() {
        return this.scaWeight;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setIban(String iban) {
        this.iban = iban;
    }

    public void setAccessType(AccessTypeTO accessType) {
        this.accessType = accessType;
    }

    public void setScaWeight(int scaWeight) {
        this.scaWeight = scaWeight;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccountAccessTO)) {
            return false;
        }
        AccountAccessTO other = (AccountAccessTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$iban = this.getIban();
        String other$iban = other.getIban();
        if (this$iban == null ? other$iban != null : !this$iban.equals(other$iban)) {
            return false;
        }
        AccessTypeTO this$accessType = this.getAccessType();
        AccessTypeTO other$accessType = other.getAccessType();
        if (this$accessType == null ? other$accessType != null : !((Object)((Object)this$accessType)).equals((Object)other$accessType)) {
            return false;
        }
        return this.getScaWeight() == other.getScaWeight();
    }

    protected boolean canEqual(Object other) {
        return other instanceof AccountAccessTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $iban = this.getIban();
        result = result * 59 + ($iban == null ? 43 : $iban.hashCode());
        AccessTypeTO $accessType = this.getAccessType();
        result = result * 59 + ($accessType == null ? 43 : ((Object)((Object)$accessType)).hashCode());
        result = result * 59 + this.getScaWeight();
        return result;
    }

    public String toString() {
        return "AccountAccessTO(id=" + this.getId() + ", iban=" + this.getIban() + ", accessType=" + (Object)((Object)this.getAccessType()) + ", scaWeight=" + this.getScaWeight() + ")";
    }

    public AccountAccessTO() {
    }

    public AccountAccessTO(String id, String iban, AccessTypeTO accessType, int scaWeight) {
        this.id = id;
        this.iban = iban;
        this.accessType = accessType;
        this.scaWeight = scaWeight;
    }
}

