/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.api.domain.um;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.adorsys.ledgers.middleware.api.domain.um.AisConsentTO;
import de.adorsys.ledgers.middleware.api.domain.um.TokenUsageTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserRoleTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@ApiModel(description="The access token object.")
public class AccessTokenTO {
    @ApiModelProperty(value="The database id of the initiator of this token")
    private String sub;
    @ApiModelProperty(value="The token identifier")
    private String jti;
    @ApiModelProperty(value="The login name of the initiator of this token")
    private String login;
    @ApiModelProperty(value="The specification of psd2 account access permission associated with this token")
    private AisConsentTO consent;
    @ApiModelProperty(value="Role to be inforced when this token is presented.")
    private UserRoleTO role;
    @ApiModelProperty(value="Issue time")
    private Date iat;
    @ApiModelProperty(value="expiration time")
    private Date exp;
    @ApiModelProperty(value="The bearer this token.")
    private Map<String, String> act = new HashMap<String, String>();
    @ApiModelProperty(value="The id of the sca object: login, payment, account access")
    @JsonProperty(value="sca_id")
    private String scaId;
    @ApiModelProperty(value="The last authorisation id leading to this token")
    @JsonProperty(value="authorisation_id")
    private String authorisationId;
    @ApiModelProperty(value="The usage of this token.")
    @JsonProperty(value="token_usage")
    private TokenUsageTO tokenUsage;

    @JsonIgnore
    public boolean hasValidConsent() {
        return this.consent != null && this.consent.isValidConsent();
    }

    public String getSub() {
        return this.sub;
    }

    public String getJti() {
        return this.jti;
    }

    public String getLogin() {
        return this.login;
    }

    public AisConsentTO getConsent() {
        return this.consent;
    }

    public UserRoleTO getRole() {
        return this.role;
    }

    public Date getIat() {
        return this.iat;
    }

    public Date getExp() {
        return this.exp;
    }

    public Map<String, String> getAct() {
        return this.act;
    }

    public String getScaId() {
        return this.scaId;
    }

    public String getAuthorisationId() {
        return this.authorisationId;
    }

    public TokenUsageTO getTokenUsage() {
        return this.tokenUsage;
    }

    public void setSub(String sub) {
        this.sub = sub;
    }

    public void setJti(String jti) {
        this.jti = jti;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public void setConsent(AisConsentTO consent) {
        this.consent = consent;
    }

    public void setRole(UserRoleTO role) {
        this.role = role;
    }

    public void setIat(Date iat) {
        this.iat = iat;
    }

    public void setExp(Date exp) {
        this.exp = exp;
    }

    public void setAct(Map<String, String> act) {
        this.act = act;
    }

    public void setScaId(String scaId) {
        this.scaId = scaId;
    }

    public void setAuthorisationId(String authorisationId) {
        this.authorisationId = authorisationId;
    }

    public void setTokenUsage(TokenUsageTO tokenUsage) {
        this.tokenUsage = tokenUsage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccessTokenTO)) {
            return false;
        }
        AccessTokenTO other = (AccessTokenTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$sub = this.getSub();
        String other$sub = other.getSub();
        if (this$sub == null ? other$sub != null : !this$sub.equals(other$sub)) {
            return false;
        }
        String this$jti = this.getJti();
        String other$jti = other.getJti();
        if (this$jti == null ? other$jti != null : !this$jti.equals(other$jti)) {
            return false;
        }
        String this$login = this.getLogin();
        String other$login = other.getLogin();
        if (this$login == null ? other$login != null : !this$login.equals(other$login)) {
            return false;
        }
        AisConsentTO this$consent = this.getConsent();
        AisConsentTO other$consent = other.getConsent();
        if (this$consent == null ? other$consent != null : !((Object)this$consent).equals(other$consent)) {
            return false;
        }
        UserRoleTO this$role = this.getRole();
        UserRoleTO other$role = other.getRole();
        if (this$role == null ? other$role != null : !((Object)((Object)this$role)).equals((Object)other$role)) {
            return false;
        }
        Date this$iat = this.getIat();
        Date other$iat = other.getIat();
        if (this$iat == null ? other$iat != null : !((Object)this$iat).equals(other$iat)) {
            return false;
        }
        Date this$exp = this.getExp();
        Date other$exp = other.getExp();
        if (this$exp == null ? other$exp != null : !((Object)this$exp).equals(other$exp)) {
            return false;
        }
        Map<String, String> this$act = this.getAct();
        Map<String, String> other$act = other.getAct();
        if (this$act == null ? other$act != null : !((Object)this$act).equals(other$act)) {
            return false;
        }
        String this$scaId = this.getScaId();
        String other$scaId = other.getScaId();
        if (this$scaId == null ? other$scaId != null : !this$scaId.equals(other$scaId)) {
            return false;
        }
        String this$authorisationId = this.getAuthorisationId();
        String other$authorisationId = other.getAuthorisationId();
        if (this$authorisationId == null ? other$authorisationId != null : !this$authorisationId.equals(other$authorisationId)) {
            return false;
        }
        TokenUsageTO this$tokenUsage = this.getTokenUsage();
        TokenUsageTO other$tokenUsage = other.getTokenUsage();
        return !(this$tokenUsage == null ? other$tokenUsage != null : !((Object)((Object)this$tokenUsage)).equals((Object)other$tokenUsage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AccessTokenTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $sub = this.getSub();
        result = result * 59 + ($sub == null ? 43 : $sub.hashCode());
        String $jti = this.getJti();
        result = result * 59 + ($jti == null ? 43 : $jti.hashCode());
        String $login = this.getLogin();
        result = result * 59 + ($login == null ? 43 : $login.hashCode());
        AisConsentTO $consent = this.getConsent();
        result = result * 59 + ($consent == null ? 43 : ((Object)$consent).hashCode());
        UserRoleTO $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : ((Object)((Object)$role)).hashCode());
        Date $iat = this.getIat();
        result = result * 59 + ($iat == null ? 43 : ((Object)$iat).hashCode());
        Date $exp = this.getExp();
        result = result * 59 + ($exp == null ? 43 : ((Object)$exp).hashCode());
        Map<String, String> $act = this.getAct();
        result = result * 59 + ($act == null ? 43 : ((Object)$act).hashCode());
        String $scaId = this.getScaId();
        result = result * 59 + ($scaId == null ? 43 : $scaId.hashCode());
        String $authorisationId = this.getAuthorisationId();
        result = result * 59 + ($authorisationId == null ? 43 : $authorisationId.hashCode());
        TokenUsageTO $tokenUsage = this.getTokenUsage();
        result = result * 59 + ($tokenUsage == null ? 43 : ((Object)((Object)$tokenUsage)).hashCode());
        return result;
    }

    public String toString() {
        return "AccessTokenTO(sub=" + this.getSub() + ", jti=" + this.getJti() + ", login=" + this.getLogin() + ", consent=" + this.getConsent() + ", role=" + (Object)((Object)this.getRole()) + ", iat=" + this.getIat() + ", exp=" + this.getExp() + ", act=" + this.getAct() + ", scaId=" + this.getScaId() + ", authorisationId=" + this.getAuthorisationId() + ", tokenUsage=" + (Object)((Object)this.getTokenUsage()) + ")";
    }
}

