/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.api.domain.payment;

import de.adorsys.ledgers.middleware.api.domain.um.AisAccountAccessInfoTO;
import de.adorsys.ledgers.middleware.api.domain.um.AisAccountAccessTypeTO;
import de.adorsys.ledgers.middleware.api.domain.um.AisConsentTO;
import java.time.format.DateTimeFormatter;
import java.util.List;

public class ConsentKeyDataTO {
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd LLLL yyyy");
    private AisConsentTO consent;

    public String template() {
        this.checkNullConsent();
        AisAccountAccessInfoTO access = this.consent.getAccess();
        if (access == null) {
            return String.format("No account access to tpp with id: %s", this.consent.getTppId());
        }
        StringBuilder b = this.prepareTemplate(access);
        b.append("TAN: %s");
        return b.toString();
    }

    public String exemptedTemplate() {
        this.checkNullConsent();
        AisAccountAccessInfoTO access = this.consent.getAccess();
        if (access == null) {
            return String.format("No account access to tpp with id: %s", this.consent.getTppId());
        }
        StringBuilder b = this.prepareTemplate(access);
        b.append("This access has been granted. No TAN entry needed.");
        return b.toString();
    }

    private StringBuilder prepareTemplate(AisAccountAccessInfoTO access) {
        StringBuilder b = new StringBuilder(String.format("Account access for TPP with id %s:%n", this.consent.getTppId()));
        if (this.consent.getFrequencyPerDay() <= 1) {
            if (this.consent.isRecurringIndicator()) {
                b.append("- Up to to 1 access per day.\n");
            } else {
                b.append("- For one time access.\n");
            }
        } else {
            b.append(String.format("- Up to %s accesses per day.%n", this.consent.getFrequencyPerDay()));
        }
        if (this.consent.getValidUntil() != null) {
            b.append(String.format("- Access valid until %s.%n", formatter.format(this.consent.getValidUntil())));
        }
        b.append("Access to following accounts:.\n");
        if (AisAccountAccessTypeTO.ALL_ACCOUNTS.equals((Object)access.getAllPsd2())) {
            b.append("All payments accounts without balances.\n");
        } else if (AisAccountAccessTypeTO.ALL_ACCOUNTS_WITH_BALANCES.equals((Object)access.getAllPsd2())) {
            b.append("All payments accounts with balances and transactions.\n");
        }
        if (AisAccountAccessTypeTO.ALL_ACCOUNTS.equals((Object)access.getAvailableAccounts())) {
            b.append("All available accounts without balances.\n");
        } else if (AisAccountAccessTypeTO.ALL_ACCOUNTS_WITH_BALANCES.equals((Object)access.getAvailableAccounts())) {
            b.append("All available accounts with balances and transactions.\n");
        }
        this.format(b, access.getAccounts(), "Without balances: %s.\n");
        this.format(b, access.getBalances(), "With balances: %s.\n");
        this.format(b, access.getTransactions(), "With balances and transactions: %s.\n");
        return b;
    }

    private void checkNullConsent() {
        if (this.consent == null) {
            throw new IllegalStateException("Not expecting consent to be null.");
        }
        if (this.consent.getTppId() == null) {
            throw new IllegalStateException("Not expecting tppId to be null.");
        }
    }

    private void format(StringBuilder b, List<String> accounts, String templ) {
        if (accounts != null && !accounts.isEmpty()) {
            b.append(String.format(templ, this.accountList(accounts)));
        }
    }

    private String accountList(List<String> accounts) {
        StringBuilder sb = new StringBuilder();
        accounts.forEach(a -> sb.append((String)a).append(" "));
        return sb.toString();
    }

    public AisConsentTO getConsent() {
        return this.consent;
    }

    public void setConsent(AisConsentTO consent) {
        this.consent = consent;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConsentKeyDataTO)) {
            return false;
        }
        ConsentKeyDataTO other = (ConsentKeyDataTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AisConsentTO this$consent = this.getConsent();
        AisConsentTO other$consent = other.getConsent();
        return !(this$consent == null ? other$consent != null : !((Object)this$consent).equals(other$consent));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConsentKeyDataTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AisConsentTO $consent = this.getConsent();
        result = result * 59 + ($consent == null ? 43 : ((Object)$consent).hashCode());
        return result;
    }

    public String toString() {
        return "ConsentKeyDataTO(consent=" + this.getConsent() + ")";
    }

    public ConsentKeyDataTO() {
    }

    public ConsentKeyDataTO(AisConsentTO consent) {
        this.consent = consent;
    }
}

