/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.api.domain.um;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class LoginKeyDataTO {
    private static final String V_00 = "V00";
    private static final int VERSION_STRING_LENGTH = 3;
    private static final String FORMAT_V00 = "yyyyMMddHHmmss";
    private static final DateTimeFormatter storage_formatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    private static final DateTimeFormatter display_formatter = DateTimeFormatter.ofPattern("dd LLLL yyyy");
    private static String curent_version;
    private static final Map<String, String> formatMap;
    private final String userId;
    private final LocalDateTime loginTime;

    public LoginKeyDataTO(String userId, LocalDateTime time) {
        this.userId = userId;
        this.loginTime = time;
    }

    public String getUserId() {
        return this.userId;
    }

    public String messageTemplate() {
        if (this.userId == null) {
            throw new IllegalStateException("Not expecting userId to be null.");
        }
        StringBuilder b = new StringBuilder(String.format("Login process started at %s for %s:\n", this.loginTime.format(display_formatter), this.userId));
        b.append("TAN: %s");
        return b.toString();
    }

    public String toOpId() {
        if (curent_version.length() != 3) {
            throw new IllegalStateException(String.format("Version string must be of length %s and shall never change.", curent_version.length()));
        }
        return curent_version + this.loginTime.format(storage_formatter) + this.userId;
    }

    public static LoginKeyDataTO fromOpId(String opId) {
        String version = StringUtils.substring((String)opId, (int)0, (int)3);
        String format = formatMap.get(version);
        if (format == null) {
            throw new IllegalStateException(String.format("Missing format with version number %s", version));
        }
        String loginDate = StringUtils.substring((String)opId, (int)3, (int)(3 + format.length()));
        String userId = StringUtils.substringAfter((String)opId, (String)loginDate);
        return new LoginKeyDataTO(userId, LocalDateTime.parse(loginDate, storage_formatter));
    }

    static {
        formatMap = new HashMap<String, String>();
        formatMap.put(V_00, FORMAT_V00);
        curent_version = V_00;
    }
}

