/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.api.service;

import de.adorsys.ledgers.middleware.api.domain.account.AccountDetailsTO;
import de.adorsys.ledgers.middleware.api.domain.account.FundsConfirmationRequestTO;
import de.adorsys.ledgers.middleware.api.domain.account.TransactionTO;
import de.adorsys.ledgers.middleware.api.domain.payment.AmountTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAConsentResponseTO;
import de.adorsys.ledgers.middleware.api.domain.um.AccountAccessTO;
import de.adorsys.ledgers.middleware.api.domain.um.AisConsentTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.api.exception.AccountNotFoundMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.AccountWithPrefixGoneMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.AccountWithSuffixExistsMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.AisConsentNotFoundMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.InsufficientPermissionMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.PaymentNotFoundMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.SCAMethodNotSupportedMiddleException;
import de.adorsys.ledgers.middleware.api.exception.SCAOperationExpiredMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.SCAOperationNotFoundMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.SCAOperationUsedOrStolenMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.SCAOperationValidationMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.TransactionNotFoundMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.UserNotFoundMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.UserScaDataNotFoundMiddlewareException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

public interface MiddlewareAccountManagementService {
    public void createDepositAccount(AccountDetailsTO var1) throws UserNotFoundMiddlewareException;

    public void createDepositAccount(AccountDetailsTO var1, List<AccountAccessTO> var2) throws UserNotFoundMiddlewareException;

    public void createDepositAccount(String var1, String var2, AccountDetailsTO var3) throws AccountWithPrefixGoneMiddlewareException, AccountWithSuffixExistsMiddlewareException, UserNotFoundMiddlewareException;

    public void grantAccessToDepositAccount(AccountAccessTO var1) throws AccountNotFoundMiddlewareException, InsufficientPermissionMiddlewareException;

    public List<AccountDetailsTO> listOfDepositAccounts();

    public AccountDetailsTO getDepositAccountById(String var1, LocalDateTime var2, boolean var3) throws AccountNotFoundMiddlewareException, InsufficientPermissionMiddlewareException;

    public AccountDetailsTO getDepositAccountByIban(String var1, LocalDateTime var2, boolean var3) throws AccountNotFoundMiddlewareException, InsufficientPermissionMiddlewareException;

    public List<AccountDetailsTO> getAllAccountDetailsByUserLogin(String var1) throws UserNotFoundMiddlewareException, AccountNotFoundMiddlewareException, InsufficientPermissionMiddlewareException;

    public TransactionTO getTransactionById(String var1, String var2) throws AccountNotFoundMiddlewareException, TransactionNotFoundMiddlewareException, InsufficientPermissionMiddlewareException;

    public List<TransactionTO> getTransactionsByDates(String var1, LocalDate var2, LocalDate var3) throws AccountNotFoundMiddlewareException, InsufficientPermissionMiddlewareException;

    public boolean confirmFundsAvailability(FundsConfirmationRequestTO var1) throws AccountNotFoundMiddlewareException;

    public String iban(String var1);

    public SCAConsentResponseTO startSCA(String var1, AisConsentTO var2) throws InsufficientPermissionMiddlewareException;

    public SCAConsentResponseTO loadSCAForAisConsent(String var1, String var2) throws SCAOperationExpiredMiddlewareException, AisConsentNotFoundMiddlewareException;

    public SCAConsentResponseTO selectSCAMethodForAisConsent(String var1, String var2, String var3) throws PaymentNotFoundMiddlewareException, SCAMethodNotSupportedMiddleException, UserScaDataNotFoundMiddlewareException, SCAOperationValidationMiddlewareException, SCAOperationNotFoundMiddlewareException, AisConsentNotFoundMiddlewareException;

    public SCAConsentResponseTO authorizeConsent(String var1, String var2, String var3) throws SCAOperationNotFoundMiddlewareException, SCAOperationValidationMiddlewareException, SCAOperationExpiredMiddlewareException, SCAOperationUsedOrStolenMiddlewareException, AisConsentNotFoundMiddlewareException;

    public BearerTokenTO grantAisConsent(AisConsentTO var1) throws AccountNotFoundMiddlewareException, InsufficientPermissionMiddlewareException;

    public void depositCash(String var1, AmountTO var2) throws AccountNotFoundMiddlewareException;
}

