/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.api.domain.payment;

import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTypeTO;

public class PaymentCoreDataTO {
    public static final String SINGLE_PAYMENT_TAN_MESSAGE_TEMPLATE = "The TAN for your one time transfer order to %s at date %s; account %s; %s %s is: ";
    public static final String PERIODIC_PAYMENT_TAN_MESSAGE_TEMPLATE = "The TAN for your recurring transfer order to %s; account %s; Day of execution %s; Rule %s, Frequency %s; Amount %s %s is: ";
    public static final String BULK_PAYMENT_TAN_MESSAGE_TEMPLATE = "The TAN for your one time bulk transfer order %s reciepient(s) with name(s) %s at date %s; account %s; %s %s is: ";
    public static final String SINGLE_PAYMENT_EXEMPTED_MESSAGE_TEMPLATE = "Your one time transfer order to %s at date %s; account %s; %s %s has been received.";
    public static final String PERIODIC_PAYMENT_EXEMPTED_MESSAGE_TEMPLATE = "Your recurring transfer order to %s; account %s; Day of execution %s; Rule %s, Frequency %s; Amount %s %s  has been received.";
    public static final String BULK_PAYMENT_EXEMPTED_MESSAGE_TEMPLATE = "Your one time bulk transfer order %s reciepient(s) with name(s) %s at date %s; account %s; %s %s has been received.";
    public static final String CANCEL_SINGLE_PAYMENT_TAN_MESSAGE_TEMPLATE = "The TAN for the cancellation of your one time transfer order to %s at date %s; account %s; %s %s is: ";
    public static final String CANCEL_PERIODIC_PAYMENT_TAN_MESSAGE_TEMPLATE = "The TAN for the cancellation of your recurring transfer order to %s; account %s; Day of execution %s; Rule %s, Frequency %s; Amount %s %s is: ";
    public static final String CANCEL_BULK_PAYMENT_TAN_MESSAGE_TEMPLATE = "The TAN for for the cancellation of your one time bulk transfer order %s reciepient(s) with name(s) %s at date %s; account %s; %s %s is: ";
    public static final String CANCEL_SINGLE_PAYMENT_EXEMPTED_MESSAGE_TEMPLATE = "The cancellation of your one time transfer order to %s at date %s; account %s; %s %s has been scheduled.";
    public static final String CANCEL_PERIODIC_PAYMENT_EXEMPTED_MESSAGE_TEMPLATE = "The cancellation of your recurring transfer order to %s; account %s; Day of execution %s; Rule %s, Frequency %s; Amount %s %s has been scheduled.";
    public static final String CANCEL_BULK_PAYMENT_EXEMPTED_MESSAGE_TEMPLATE = "The cancellation of your one time bulk transfer order %s reciepient(s) with name(s) %s at date %s; account %s; %s %s has been scheduled.";
    private String paymentId;
    private String creditorName;
    private String creditorIban;
    private String amount;
    private String currency;
    private String dayOfExecution;
    private String executionRule;
    private String frequency;
    private String paymentType;
    private String paymentsSize;
    private String requestedExecutionDate;
    private boolean cancellation;

    public String getPaymentId() {
        return this.paymentId;
    }

    public void setPaymentId(String paymentId) {
        this.paymentId = paymentId;
    }

    public String getCreditorName() {
        return this.creditorName;
    }

    public void setCreditorName(String creditorName) {
        this.creditorName = creditorName;
    }

    public String getCreditorIban() {
        return this.creditorIban;
    }

    public void setCreditorIban(String creditorIban) {
        this.creditorIban = creditorIban;
    }

    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getDayOfExecution() {
        return this.dayOfExecution;
    }

    public void setDayOfExecution(String dayOfExecution) {
        this.dayOfExecution = dayOfExecution;
    }

    public String getExecutionRule() {
        return this.executionRule;
    }

    public void setExecutionRule(String executionRule) {
        this.executionRule = executionRule;
    }

    public String getFrequency() {
        return this.frequency;
    }

    public void setFrequency(String frequency) {
        this.frequency = frequency;
    }

    public String getPaymentType() {
        return this.paymentType;
    }

    public void setPaymentType(String paymentType) {
        this.paymentType = paymentType;
    }

    public String getPaymentsSize() {
        return this.paymentsSize;
    }

    public void setPaymentsSize(String paymentsSize) {
        this.paymentsSize = paymentsSize;
    }

    public String getRequestedExecutionDate() {
        return this.requestedExecutionDate;
    }

    public void setRequestedExecutionDate(String requestedExecutionDate) {
        this.requestedExecutionDate = requestedExecutionDate;
    }

    public boolean isCancellation() {
        return this.cancellation;
    }

    public void setCancellation(boolean cancellation) {
        this.cancellation = cancellation;
    }

    public String template() {
        PaymentTypeTO pt = PaymentTypeTO.valueOf(this.paymentType);
        switch (pt) {
            case PERIODIC: {
                return this.cancellation ? this.cancelPeriodicPaymentMessageTemplate() : this.periodicPaymentMessageTemplate();
            }
            case BULK: {
                return this.cancellation ? this.cancelBulkPaymentMessageTemplate() : this.bulkPaymentMessageTemplate();
            }
        }
        return this.cancellation ? this.cancelSinglePaymentMessageTemplate() : this.singlePaymentMessageTemplate();
    }

    public String exemptedTemplate() {
        PaymentTypeTO pt = PaymentTypeTO.valueOf(this.paymentType);
        switch (pt) {
            case PERIODIC: {
                return this.cancellation ? this.cancelPeriodicPaymentExemptedMessageTemplate() : this.periodicPaymentExemptedMessageTemplate();
            }
            case BULK: {
                return this.cancellation ? this.cancelBulkPaymentExemptedMessageTemplate() : this.bulkPaymentExemptedMessageTemplate();
            }
        }
        return this.cancellation ? this.cancelSinglePaymentExemptedMessageTemplate() : this.singlePaymentExemptedMessageTemplate();
    }

    private String singlePaymentMessageTemplate() {
        return String.format(SINGLE_PAYMENT_TAN_MESSAGE_TEMPLATE, this.creditorName, this.requestedExecutionDate, this.creditorIban, this.currency, this.amount) + "%s";
    }

    private String periodicPaymentMessageTemplate() {
        return String.format(PERIODIC_PAYMENT_TAN_MESSAGE_TEMPLATE, this.creditorName, this.creditorIban, this.dayOfExecution, this.executionRule, this.frequency, this.currency, this.amount) + "%s";
    }

    private String bulkPaymentMessageTemplate() {
        return String.format(BULK_PAYMENT_TAN_MESSAGE_TEMPLATE, this.paymentsSize, this.creditorName, this.requestedExecutionDate, this.creditorIban, this.currency, this.amount) + "%s";
    }

    private String cancelSinglePaymentMessageTemplate() {
        return String.format(CANCEL_SINGLE_PAYMENT_TAN_MESSAGE_TEMPLATE, this.creditorName, this.requestedExecutionDate, this.creditorIban, this.currency, this.amount) + "%s";
    }

    private String cancelPeriodicPaymentMessageTemplate() {
        return String.format(CANCEL_PERIODIC_PAYMENT_TAN_MESSAGE_TEMPLATE, this.creditorName, this.creditorIban, this.dayOfExecution, this.executionRule, this.frequency, this.currency, this.amount) + "%s";
    }

    private String cancelBulkPaymentMessageTemplate() {
        return String.format(CANCEL_BULK_PAYMENT_TAN_MESSAGE_TEMPLATE, this.paymentsSize, this.creditorName, this.requestedExecutionDate, this.creditorIban, this.currency, this.amount) + "%s";
    }

    private String singlePaymentExemptedMessageTemplate() {
        return String.format(SINGLE_PAYMENT_TAN_MESSAGE_TEMPLATE, this.creditorName, this.requestedExecutionDate, this.creditorIban, this.currency, this.amount) + "%s";
    }

    private String periodicPaymentExemptedMessageTemplate() {
        return String.format(PERIODIC_PAYMENT_TAN_MESSAGE_TEMPLATE, this.creditorName, this.creditorIban, this.dayOfExecution, this.executionRule, this.frequency, this.currency, this.amount) + "%s";
    }

    private String bulkPaymentExemptedMessageTemplate() {
        return String.format(BULK_PAYMENT_TAN_MESSAGE_TEMPLATE, this.paymentsSize, this.creditorName, this.requestedExecutionDate, this.creditorIban, this.currency, this.amount) + "%s";
    }

    private String cancelSinglePaymentExemptedMessageTemplate() {
        return String.format(CANCEL_SINGLE_PAYMENT_TAN_MESSAGE_TEMPLATE, this.creditorName, this.requestedExecutionDate, this.creditorIban, this.currency, this.amount) + "%s";
    }

    private String cancelPeriodicPaymentExemptedMessageTemplate() {
        return String.format(CANCEL_PERIODIC_PAYMENT_TAN_MESSAGE_TEMPLATE, this.creditorName, this.creditorIban, this.dayOfExecution, this.executionRule, this.frequency, this.currency, this.amount) + "%s";
    }

    private String cancelBulkPaymentExemptedMessageTemplate() {
        return String.format(CANCEL_BULK_PAYMENT_TAN_MESSAGE_TEMPLATE, this.paymentsSize, this.creditorName, this.requestedExecutionDate, this.creditorIban, this.currency, this.amount) + "%s";
    }
}

