/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.resource;

import de.adorsys.ledgers.middleware.api.service.EmailVerificationService;
import de.adorsys.ledgers.middleware.impl.config.EmailVerificationProperties;
import de.adorsys.ledgers.middleware.rest.annotation.MiddlewareUserResource;
import de.adorsys.ledgers.middleware.rest.resource.ScaVerificationRestAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/emails"})
@MiddlewareUserResource
public class ScaVerificationResource
implements ScaVerificationRestAPI {
    private static final Logger log = LoggerFactory.getLogger(ScaVerificationResource.class);
    private final EmailVerificationService emailVerificationService;
    private final EmailVerificationProperties verificationProperties;

    public ResponseEntity<Void> sendEmailVerification(String email) {
        String token = this.emailVerificationService.createVerificationToken(email);
        this.emailVerificationService.sendVerificationEmail(token);
        return ResponseEntity.ok().build();
    }

    public ResponseEntity<Void> confirmVerificationToken(String token) {
        HttpHeaders headers = new HttpHeaders();
        String location = this.verificationProperties.getPage().getSuccess();
        try {
            this.emailVerificationService.confirmUser(token);
        }
        catch (Exception e) {
            location = this.verificationProperties.getPage().getFail();
        }
        headers.add("Location", location);
        return new ResponseEntity((MultiValueMap)headers, HttpStatus.FOUND);
    }

    public ScaVerificationResource(EmailVerificationService emailVerificationService, EmailVerificationProperties verificationProperties) {
        this.emailVerificationService = emailVerificationService;
        this.verificationProperties = verificationProperties;
    }
}

