/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.resource;

import de.adorsys.ledgers.middleware.api.domain.sca.GlobalScaResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.StartScaOprTO;
import de.adorsys.ledgers.middleware.api.service.MiddlewareRedirectScaService;
import de.adorsys.ledgers.middleware.rest.annotation.MiddlewareUserResource;
import de.adorsys.ledgers.middleware.rest.resource.RedirectScaRestAPI;
import de.adorsys.ledgers.middleware.rest.security.ScaInfoHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sca"})
@MiddlewareUserResource
public class RedirectScaResource
implements RedirectScaRestAPI {
    private static final Logger log = LoggerFactory.getLogger(RedirectScaResource.class);
    private final ScaInfoHolder scaInfoHolder;
    private final MiddlewareRedirectScaService scaService;

    @PreAuthorize(value="hasScaScope() and hasAccessToAccountByScaOperation(#startScaOpr)")
    public ResponseEntity<GlobalScaResponseTO> startSca(StartScaOprTO startScaOpr) {
        return ResponseEntity.ok((Object)this.scaService.startScaOperation(startScaOpr, this.scaInfoHolder.getScaInfo()));
    }

    @PreAuthorize(value="hasScaScope() and hasAccessToAccountByAuthorizationId(#authorisationId)")
    public ResponseEntity<GlobalScaResponseTO> getSCA(String authorisationId) {
        return ResponseEntity.ok((Object)this.scaService.getMethods(authorisationId, this.scaInfoHolder.getScaInfo()));
    }

    @PreAuthorize(value="hasScaScope() and hasAccessToAccountByAuthorizationId(#authorisationId)")
    public ResponseEntity<GlobalScaResponseTO> selectMethod(String authorisationId, String scaMethodId) {
        return ResponseEntity.ok((Object)this.scaService.selectMethod(this.scaInfoHolder.getScaInfoWithScaMethodIdAndAuthorisationId(scaMethodId, authorisationId)));
    }

    @PreAuthorize(value="hasScaScope() and hasAccessToAccountByAuthorizationId(#authorisationId)")
    public ResponseEntity<GlobalScaResponseTO> validateScaCode(String authorisationId, String authCode) {
        return ResponseEntity.ok((Object)this.scaService.confirmAuthorization(this.scaInfoHolder.getScaInfoWithAuthCodeAndAuthorisationId(authCode, authorisationId)));
    }

    public RedirectScaResource(ScaInfoHolder scaInfoHolder, MiddlewareRedirectScaService scaService) {
        this.scaInfoHolder = scaInfoHolder;
        this.scaService = scaService;
    }
}

