/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.resource;

import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTypeTO;
import de.adorsys.ledgers.middleware.api.domain.sca.GlobalScaResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.OpTypeTO;
import de.adorsys.ledgers.middleware.api.domain.um.AisConsentTO;
import de.adorsys.ledgers.middleware.api.service.OperationService;
import de.adorsys.ledgers.middleware.rest.annotation.MiddlewareUserResource;
import de.adorsys.ledgers.middleware.rest.resource.OperationInitiationRestApi;
import de.adorsys.ledgers.middleware.rest.security.ScaInfoHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@MiddlewareUserResource
@RequestMapping(value={"/operation"})
public class OperationInitiationResource
implements OperationInitiationRestApi {
    private static final Logger log = LoggerFactory.getLogger(OperationInitiationResource.class);
    private final OperationService operationService;
    private final ScaInfoHolder scaInfoHolder;

    @PreAuthorize(value="hasAccessToAccountWithIban(#payment.debtorAccount.iban)")
    public ResponseEntity<GlobalScaResponseTO> initiatePayment(PaymentTypeTO paymentType, PaymentTO payment) {
        return new ResponseEntity((Object)this.operationService.resolveInitiation(OpTypeTO.PAYMENT, null, (Object)payment, this.scaInfoHolder.getScaInfo()), HttpStatus.CREATED);
    }

    @PreAuthorize(value="hasAccessToAccountByPaymentId(#opId)")
    public ResponseEntity<GlobalScaResponseTO> initiatePmtCancellation(String opId) {
        return new ResponseEntity((Object)this.operationService.resolveInitiation(OpTypeTO.CANCEL_PAYMENT, opId, null, this.scaInfoHolder.getScaInfo()), HttpStatus.CREATED);
    }

    @PreAuthorize(value="hasAnyRole('STAFF','CUSTOMER') and hasAccessToAccountsWithIbans(#aisConsent.access.listedAccountsIbans)")
    public ResponseEntity<GlobalScaResponseTO> initiateAisConsent(AisConsentTO aisConsent) {
        return new ResponseEntity((Object)this.operationService.resolveInitiation(OpTypeTO.CONSENT, null, (Object)aisConsent, this.scaInfoHolder.getScaInfo()), HttpStatus.CREATED);
    }

    @PreAuthorize(value="hasPartialScope() and hasAccessToAccountByPaymentId(#opId)")
    public ResponseEntity<GlobalScaResponseTO> execution(OpTypeTO opType, String opId) {
        return ResponseEntity.ok((Object)this.operationService.execute(opType, opId, this.scaInfoHolder.getScaInfo()));
    }

    public OperationInitiationResource(OperationService operationService, ScaInfoHolder scaInfoHolder) {
        this.operationService = operationService;
        this.scaInfoHolder = scaInfoHolder;
    }
}

