/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.resource;

import de.adorsys.ledgers.keycloak.client.api.KeycloakTokenService;
import de.adorsys.ledgers.middleware.api.domain.um.UserRoleTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.ledgers.middleware.api.exception.MiddlewareErrorCode;
import de.adorsys.ledgers.middleware.api.exception.MiddlewareModuleException;
import de.adorsys.ledgers.middleware.api.service.AppManagementService;
import de.adorsys.ledgers.middleware.api.service.MiddlewareUserManagementService;
import de.adorsys.ledgers.middleware.rest.annotation.MiddlewareUserResource;
import de.adorsys.ledgers.middleware.rest.resource.AppMgmtRestAPI;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/management/app"})
@MiddlewareUserResource
public class AppMgmtResource
implements AppMgmtRestAPI {
    private static final Logger log = LoggerFactory.getLogger(AppMgmtResource.class);
    private static final String ADMIN_FIRST = "Admin user can not be created after initialization. This must be the first user of the system.";
    private final AppManagementService appManagementService;
    private final MiddlewareUserManagementService userManagementService;
    private final KeycloakTokenService tokenService;

    public ResponseEntity<String> ping() {
        return ResponseEntity.ok((Object)"pong");
    }

    @PreAuthorize(value="hasRole('SYSTEM')")
    public ResponseEntity<Void> initApp() {
        this.appManagementService.initApp();
        return ResponseEntity.ok().build();
    }

    public ResponseEntity<Void> admin(@RequestBody UserTO adminUser) {
        List users = this.userManagementService.listUsers(0, 1);
        if (!users.isEmpty()) {
            log.error(ADMIN_FIRST);
            throw MiddlewareModuleException.builder().errorCode(MiddlewareErrorCode.REQUEST_VALIDATION_FAILURE).devMsg(ADMIN_FIRST).build();
        }
        UserTO user = new UserTO();
        user.setLogin(adminUser.getLogin());
        user.setPin(adminUser.getPin());
        user.setEmail(adminUser.getEmail());
        user.getUserRoles().add(UserRoleTO.SYSTEM);
        this.userManagementService.create(user);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).build();
    }

    public AppMgmtResource(AppManagementService appManagementService, MiddlewareUserManagementService userManagementService, KeycloakTokenService tokenService) {
        this.appManagementService = appManagementService;
        this.userManagementService = userManagementService;
        this.tokenService = tokenService;
    }
}

