/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.filter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.ledgers.middleware.api.service.CurrencyService;
import de.adorsys.ledgers.middleware.rest.filter.MultiReadHttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.IBANValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class ValidationFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(ValidationFilter.class);
    private static final String IBAN = "iban";
    private static final String CURRENCY = "currency";
    private final CurrencyService currencyService;
    private final ObjectMapper mapper;

    public void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        MultiReadHttpServletRequest servletRequest = new MultiReadHttpServletRequest(request);
        boolean isXmlContent = StringUtils.equals((CharSequence)MediaType.APPLICATION_XML.toString(), (CharSequence)servletRequest.getHeader("Content-Type"));
        if (isXmlContent) {
            chain.doFilter((ServletRequest)servletRequest, (ServletResponse)response);
            return;
        }
        try {
            Supplier<Optional> supplierIban = () -> this.validate(this.readValuesByField(servletRequest, IBAN), v -> IBANValidator.getInstance().isValid(v));
            Supplier<Optional> supplierCurrency = () -> this.validate(this.readValuesByField(servletRequest, CURRENCY), this::isSupportedCurrency);
            Optional<String> combined = ValidationFilter.findFirstPresent(supplierIban, supplierCurrency);
            if (combined.isPresent()) {
                this.buildError(response, combined.get());
                return;
            }
        }
        catch (IOException e) {
            response.sendError(400, String.format("Could not parse request body, msg: %s", e.getMessage()));
            return;
        }
        chain.doFilter((ServletRequest)servletRequest, (ServletResponse)response);
    }

    private Optional<String> validate(Collection<String> values, Predicate<String> predicate) {
        return values.stream().filter(predicate.negate()).findFirst();
    }

    private Collection<String> readValuesByField(MultiReadHttpServletRequest servletRequest, String fieldName) {
        JsonNode jsonNode = this.mapper.readTree((InputStream)servletRequest.getInputStream());
        ArrayList<String> values = jsonNode != null ? jsonNode.findValuesAsText(fieldName).stream().filter(a -> !a.equals("null")).collect(Collectors.toList()) : new ArrayList<String>();
        Optional.ofNullable(servletRequest.getParameter(fieldName)).ifPresent(values::add);
        return values;
    }

    private boolean isSupportedCurrency(String currency) {
        return this.currencyService.getSupportedCurrencies().stream().anyMatch(c -> StringUtils.equals((CharSequence)c.getCurrencyCode(), (CharSequence)currency));
    }

    @SafeVarargs
    private static Optional<String> findFirstPresent(Supplier<Optional<String>> ... suppliers) {
        return Stream.of(suppliers).map(Supplier::get).filter(Optional::isPresent).findFirst().orElseGet(Optional::empty);
    }

    private void buildError(HttpServletResponse response, String value) throws IOException {
        log.error("Invalid value: {}", (Object)value);
        response.sendError(400, String.format("Invalid value: %s", value));
    }

    public ValidationFilter(CurrencyService currencyService, ObjectMapper mapper) {
        this.currencyService = currencyService;
        this.mapper = mapper;
    }
}

