/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.security;

import de.adorsys.ledgers.middleware.api.domain.sca.ScaInfoTO;
import de.adorsys.ledgers.middleware.api.domain.um.AccessTokenTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.api.domain.um.TokenUsageTO;
import de.adorsys.ledgers.middleware.rest.security.ScaInfoHolder;
import de.adorsys.ledgers.um.api.service.UserService;
import org.springframework.stereotype.Component;

@Component
public class ScaInfoHolderImpl
implements ScaInfoHolder {
    private final AccessTokenTO accessTokenTO;
    private final UserService userService;
    private final BearerTokenTO bearerTokenTO;

    @Override
    public String getUserId() {
        return this.userService.findByLogin(this.accessTokenTO.getLogin()).getId();
    }

    @Override
    public TokenUsageTO getTokenUsageTO() {
        return this.accessTokenTO.getTokenUsage();
    }

    @Override
    public ScaInfoTO getScaInfo() {
        return this.buildScaInfo();
    }

    @Override
    public ScaInfoTO getScaInfoWithScaMethodIdAndAuthorisationId(String scaMethodId, String authorizationId) {
        ScaInfoTO info = this.buildScaInfo();
        info.setScaMethodId(scaMethodId);
        info.setAuthorisationId(authorizationId);
        return info;
    }

    @Override
    public ScaInfoTO getScaInfoWithAuthCodeAndAuthorisationId(String authCode, String authorizationId) {
        ScaInfoTO info = this.buildScaInfo();
        info.setAuthCode(authCode);
        info.setAuthorisationId(authorizationId);
        return info;
    }

    private ScaInfoTO buildScaInfo() {
        ScaInfoTO info = new ScaInfoTO();
        info.setUserId(this.getUserId());
        info.setAuthorisationId(this.accessTokenTO.getAuthorisationId());
        info.setScaId(this.accessTokenTO.getScaId());
        info.setUserRole(this.accessTokenTO.getRole());
        info.setUserLogin(this.accessTokenTO.getLogin());
        info.setAccessToken(this.accessTokenTO.getAccessToken());
        info.setBearerToken(this.bearerTokenTO);
        return info;
    }

    public ScaInfoHolderImpl(AccessTokenTO accessTokenTO, UserService userService, BearerTokenTO bearerTokenTO) {
        this.accessTokenTO = accessTokenTO;
        this.userService = userService;
        this.bearerTokenTO = bearerTokenTO;
    }
}

