/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.resource;

import de.adorsys.ledgers.middleware.api.domain.general.RevertRequestTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaInfoTO;
import de.adorsys.ledgers.middleware.api.domain.um.AccountAccessTO;
import de.adorsys.ledgers.middleware.api.domain.um.ScaUserDataTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserRoleTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.ledgers.middleware.api.service.MiddlewareRecoveryService;
import de.adorsys.ledgers.middleware.api.service.MiddlewareUserManagementService;
import de.adorsys.ledgers.middleware.rest.annotation.MiddlewareUserResource;
import de.adorsys.ledgers.middleware.rest.resource.UserMgmtStaffResourceAPI;
import de.adorsys.ledgers.middleware.rest.security.ScaInfoHolder;
import de.adorsys.ledgers.util.domain.CustomPageImpl;
import de.adorsys.ledgers.util.domain.CustomPageableImpl;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@MiddlewareUserResource
@RequestMapping(value={"/staff-access/users"})
public class UserMgmtStaffResource
implements UserMgmtStaffResourceAPI {
    private final MiddlewareUserManagementService middlewareUserService;
    private final ScaInfoHolder scaInfoHolder;
    private final MiddlewareRecoveryService middlewareRecoveryService;

    @PreAuthorize(value="isNewStaffUser(#branchStaff)")
    public ResponseEntity<UserTO> register(String branch, UserTO branchStaff) {
        branchStaff.setBranch(branch);
        branchStaff.setUserRoles(Collections.singletonList(UserRoleTO.STAFF));
        UserTO user = this.middlewareUserService.create(branchStaff);
        user.setPin(null);
        return ResponseEntity.ok((Object)user);
    }

    @PreAuthorize(value="hasManagerAccessToUser(#user.id)")
    public ResponseEntity<UserTO> modifyUser(String branch, UserTO user) {
        return ResponseEntity.ok((Object)this.middlewareUserService.updateUser(branch, user));
    }

    @PreAuthorize(value="hasRole('STAFF')")
    public ResponseEntity<UserTO> createUser(UserTO user) {
        UserTO branchStaff = this.middlewareUserService.findById(this.scaInfoHolder.getScaInfo().getUserId());
        user.setBranch(branchStaff.getBranch());
        user.getUserRoles().removeAll(Arrays.asList(UserRoleTO.SYSTEM, UserRoleTO.TECHNICAL));
        UserTO newUser = this.middlewareUserService.create(user);
        newUser.setPin(null);
        return ResponseEntity.ok((Object)newUser);
    }

    @PreAuthorize(value="hasRole('STAFF')")
    public ResponseEntity<CustomPageImpl<UserTO>> getBranchUsersByRoles(List<UserRoleTO> roles, String queryParam, Boolean blockedParam, int page, int size) {
        CustomPageableImpl pageable = new CustomPageableImpl(page, size);
        UserTO branchStaff = this.middlewareUserService.findById(this.scaInfoHolder.getUserId());
        CustomPageImpl users = this.middlewareUserService.getUsersByBranchAndRoles("", branchStaff.getBranch(), "", queryParam, roles, blockedParam, pageable);
        return ResponseEntity.ok((Object)users);
    }

    @PreAuthorize(value="hasRole('STAFF')")
    public ResponseEntity<List<String>> getBranchUserLogins() {
        UserTO branchStaff = this.middlewareUserService.findById(this.scaInfoHolder.getUserId());
        List users = this.middlewareUserService.getBranchUserLogins(branchStaff.getBranch());
        return ResponseEntity.ok((Object)users);
    }

    @PreAuthorize(value="hasRole('SYSTEM')")
    public ResponseEntity<List<String>> getBranchUserLoginsByBranchId(String branchId) {
        UserTO branchStaff = this.middlewareUserService.findById(branchId);
        List users = this.middlewareUserService.getBranchUserLogins(branchStaff.getBranch());
        return ResponseEntity.ok((Object)users);
    }

    @PreAuthorize(value="hasManagerAccessToUser(#userId)")
    public ResponseEntity<UserTO> getBranchUserById(String userId) {
        UserTO user = this.middlewareUserService.findById(userId);
        return ResponseEntity.ok((Object)user);
    }

    @PreAuthorize(value="hasManagerAccessToUser(#userId)")
    public ResponseEntity<Void> updateUserScaData(String userId, List<ScaUserDataTO> data) {
        UserTO userWithUpdatedSca = this.middlewareUserService.updateScaData(this.middlewareUserService.findById(userId).getLogin(), data);
        URI uri = UriComponentsBuilder.fromUriString((String)("/staff-access/users/" + userWithUpdatedSca.getId())).build().toUri();
        return ResponseEntity.created((URI)uri).build();
    }

    @PreAuthorize(value="hasAnyRole('STAFF','SYSTEM')")
    public ResponseEntity<Void> updateAccountAccessForUser(String userId, AccountAccessTO access) {
        ScaInfoTO scaInfo = this.scaInfoHolder.getScaInfo();
        this.middlewareUserService.updateAccountAccess(scaInfo, userId, access);
        return new ResponseEntity(HttpStatus.OK);
    }

    @PreAuthorize(value="hasManagerAccessToUser(#userId)")
    public ResponseEntity<Boolean> changeStatus(String userId) {
        return ResponseEntity.ok((Object)this.middlewareUserService.changeStatus(userId, false));
    }

    @PreAuthorize(value="hasAnyRole('STAFF') and isSameUser(#request.branchId)")
    public ResponseEntity<Void> revertDatabase(RevertRequestTO request) {
        this.middlewareRecoveryService.revertDatabase(request.getBranchId(), request.getRecoveryPointId());
        return new ResponseEntity(HttpStatus.OK);
    }

    public UserMgmtStaffResource(MiddlewareUserManagementService middlewareUserService, ScaInfoHolder scaInfoHolder, MiddlewareRecoveryService middlewareRecoveryService) {
        this.middlewareUserService = middlewareUserService;
        this.scaInfoHolder = scaInfoHolder;
        this.middlewareRecoveryService = middlewareRecoveryService;
    }
}

