/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.resource;

import de.adorsys.ledgers.middleware.api.domain.account.AccountReferenceTO;
import de.adorsys.ledgers.middleware.api.domain.sca.AuthConfirmationTO;
import de.adorsys.ledgers.middleware.api.domain.um.ScaUserDataTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserRoleTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.ledgers.middleware.api.service.MiddlewareAuthConfirmationService;
import de.adorsys.ledgers.middleware.api.service.MiddlewareUserManagementService;
import de.adorsys.ledgers.middleware.rest.annotation.MiddlewareUserResource;
import de.adorsys.ledgers.middleware.rest.resource.UserMgmtRestAPI;
import de.adorsys.ledgers.middleware.rest.security.ScaInfoHolder;
import java.net.URI;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/users"})
@MiddlewareUserResource
public class UserMgmtResource
implements UserMgmtRestAPI {
    private static final Logger log = LoggerFactory.getLogger(UserMgmtResource.class);
    private final MiddlewareUserManagementService middlewareUserService;
    private final MiddlewareAuthConfirmationService authConfirmationService;
    private final ScaInfoHolder scaInfoHolder;

    @PreAuthorize(value="hasAccessToAccountByLogin(#login, #iban)")
    public ResponseEntity<Boolean> multilevel(String login, String iban) {
        return ResponseEntity.ok((Object)this.middlewareUserService.checkMultilevelScaRequired(login, iban));
    }

    @PreAuthorize(value="hasAccessToAccountsByLogin(#login, #references)")
    public ResponseEntity<Boolean> multilevelAccounts(String login, List<AccountReferenceTO> references) {
        return ResponseEntity.ok((Object)this.middlewareUserService.checkMultilevelScaRequired(login, references));
    }

    public ResponseEntity<UserTO> register(String login, String email, String pin, UserRoleTO role) {
        UserTO created = this.middlewareUserService.create(new UserTO(login, email, pin, role));
        created.setPin(null);
        return ResponseEntity.ok((Object)created);
    }

    @PreAuthorize(value="hasManagerAccessToUser(#userId)")
    public ResponseEntity<UserTO> getUserById(String userId) {
        return ResponseEntity.ok((Object)this.middlewareUserService.findById(userId));
    }

    public ResponseEntity<UserTO> getUser() {
        return ResponseEntity.ok((Object)this.middlewareUserService.findById(this.scaInfoHolder.getUserId()));
    }

    @PreAuthorize(value="isSameUser(#user.id)")
    public ResponseEntity<Void> editSelf(UserTO user) {
        this.middlewareUserService.editBasicSelf(this.scaInfoHolder.getUserId(), user);
        return ResponseEntity.accepted().build();
    }

    public ResponseEntity<Void> updateUserScaData(List<ScaUserDataTO> data) {
        UserTO initiator = this.middlewareUserService.findById(this.scaInfoHolder.getUserId());
        UserTO user = this.middlewareUserService.updateScaData(initiator.getLogin(), data);
        URI uri = UriComponentsBuilder.fromUriString((String)("/users/" + user.getId())).build().toUri();
        return ResponseEntity.created((URI)uri).build();
    }

    public ResponseEntity<AuthConfirmationTO> verifyAuthConfirmationCode(String authorisationId, String authConfirmCode) {
        return ResponseEntity.ok((Object)this.authConfirmationService.verifyAuthConfirmationCode(authorisationId, authConfirmCode, this.scaInfoHolder.getScaInfo().getUserLogin()));
    }

    public ResponseEntity<AuthConfirmationTO> completeAuthConfirmation(String authorisationId, boolean authCodeConfirmed) {
        return ResponseEntity.ok((Object)this.authConfirmationService.completeAuthConfirmation(authorisationId, authCodeConfirmed, this.scaInfoHolder.getScaInfo().getUserLogin()));
    }

    public ResponseEntity<Void> resetPasswordViaEmail(String login) {
        this.middlewareUserService.resetPasswordViaEmail(login);
        return ResponseEntity.noContent().build();
    }

    public UserMgmtResource(MiddlewareUserManagementService middlewareUserService, MiddlewareAuthConfirmationService authConfirmationService, ScaInfoHolder scaInfoHolder) {
        this.middlewareUserService = middlewareUserService;
        this.authConfirmationService = authConfirmationService;
        this.scaInfoHolder = scaInfoHolder;
    }
}

