/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.resource;

import de.adorsys.ledgers.middleware.api.domain.oauth.OauthCodeResponseTO;
import de.adorsys.ledgers.middleware.api.domain.oauth.OauthServerInfoTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.api.service.MiddlewareOauthService;
import de.adorsys.ledgers.middleware.rest.annotation.MiddlewareResetResource;
import de.adorsys.ledgers.middleware.rest.resource.OauthRestApi;
import de.adorsys.ledgers.middleware.rest.security.ScaInfoHolder;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@MiddlewareResetResource
@RequestMapping(value={"/oauth"})
public class OauthResources
implements OauthRestApi {
    private final MiddlewareOauthService middlewareOauthService;
    private final ScaInfoHolder scaInfoHolder;

    public ResponseEntity<OauthCodeResponseTO> oauthCode(String login, String pin, String redirectUri) {
        return ResponseEntity.ok((Object)this.middlewareOauthService.oauthCode(login, pin, redirectUri));
    }

    public ResponseEntity<OauthCodeResponseTO> oauthCode(String redirectUri) {
        return ResponseEntity.ok((Object)this.middlewareOauthService.oauthCode(this.scaInfoHolder.getScaInfo(), redirectUri));
    }

    public ResponseEntity<BearerTokenTO> oauthToken(String code) {
        return ResponseEntity.ok((Object)this.middlewareOauthService.oauthToken(code));
    }

    public ResponseEntity<OauthServerInfoTO> oauthServerInfo() {
        return ResponseEntity.ok((Object)this.middlewareOauthService.oauthServerInfo());
    }

    public OauthResources(MiddlewareOauthService middlewareOauthService, ScaInfoHolder scaInfoHolder) {
        this.middlewareOauthService = middlewareOauthService;
        this.scaInfoHolder = scaInfoHolder;
    }
}

