/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.filter;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiReadHttpServletRequest
extends HttpServletRequestWrapper {
    private static final Logger log = LoggerFactory.getLogger(MultiReadHttpServletRequest.class);
    private String requestBody;

    public MultiReadHttpServletRequest(HttpServletRequest request) {
        super(request);
        try {
            this.requestBody = request.getReader().lines().collect(Collectors.joining(System.lineSeparator()));
        }
        catch (IOException e) {
            log.error("MultiReadHttpServletRequest exception: {}", (Object)e.getMessage());
        }
    }

    public ServletInputStream getInputStream() {
        final ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.requestBody.getBytes(StandardCharsets.UTF_8));
        return new ServletInputStream(){

            public boolean isFinished() {
                return byteArrayInputStream.available() == 0;
            }

            public boolean isReady() {
                return true;
            }

            public void setReadListener(ReadListener readListener) {
            }

            public int read() {
                return byteArrayInputStream.read();
            }
        };
    }

    public BufferedReader getReader() {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), StandardCharsets.UTF_8));
    }
}

