/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.security;

import de.adorsys.ledgers.keycloak.client.mapper.KeycloakAuthMapper;
import de.adorsys.ledgers.middleware.api.domain.account.AccountDetailsTO;
import de.adorsys.ledgers.middleware.api.domain.account.AccountIdentifierTypeTO;
import de.adorsys.ledgers.middleware.api.domain.account.AccountReferenceTO;
import de.adorsys.ledgers.middleware.api.domain.sca.OpTypeTO;
import de.adorsys.ledgers.middleware.api.domain.sca.StartScaOprTO;
import de.adorsys.ledgers.middleware.api.domain.um.AccessTokenTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserRoleTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.ledgers.middleware.api.service.MiddlewareAccountManagementService;
import de.adorsys.ledgers.middleware.api.service.MiddlewarePaymentService;
import de.adorsys.ledgers.middleware.api.service.MiddlewareRedirectScaService;
import de.adorsys.ledgers.middleware.api.service.MiddlewareUserManagementService;
import de.adorsys.ledgers.middleware.rest.security.SecurityExpressionAdapter;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;
import org.springframework.security.core.Authentication;

public class AccountAccessMethodSecurityExpressionRoot
extends SecurityExpressionAdapter {
    public AccountAccessMethodSecurityExpressionRoot(Authentication authentication, MiddlewareAccountManagementService accountService, MiddlewarePaymentService paymentService, KeycloakAuthMapper authMapper, MiddlewareUserManagementService userManagementService, MiddlewareRedirectScaService scaService) {
        super(authentication, accountService, paymentService, userManagementService, authMapper, scaService);
    }

    public boolean isNewStaffUser(UserTO user) {
        return CollectionUtils.isNotEmpty((Collection)user.getUserRoles()) && user.getUserRoles().contains(UserRoleTO.SYSTEM) || this.userManagementService.countUsersByBranch(user.getId()) == 0;
    }

    public boolean hasManagerAccessToAccountIban(String iban) {
        UserTO user = this.user();
        return this.hasAnyRole(new String[]{UserRoleTO.SYSTEM.name(), UserRoleTO.STAFF.name()}) && user.isEnabled() && this.hasManagerAccessIban(iban, user);
    }

    public boolean hasManagerAccessToAccountId(String accountId) {
        UserTO user = this.user();
        return this.hasAnyRole(new String[]{UserRoleTO.SYSTEM.name(), UserRoleTO.STAFF.name()}) && user.isEnabled() && this.hasManagerAccessId(accountId, user);
    }

    public boolean isNewAccountAndCanBeCreatedForUser(AccountDetailsTO account, String userId) {
        List accounts = this.accountService.getAccountsByIbanAndCurrency(account.getIban(), "");
        return CollectionUtils.isEmpty((Collection)accounts) || accounts.stream().map(AccountDetailsTO::getCurrency).noneMatch(c -> account.getCurrency() == c) && this.userManagementService.findById(userId).hasAccessToAccountWithIban(account.getIban());
    }

    public boolean hasManagerAccessToUser(String userId) {
        UserTO user = this.user();
        return this.hasAnyRole(new String[]{UserRoleTO.SYSTEM.name(), UserRoleTO.STAFF.name()}) && user.isEnabled() && this.hasAccessToUser(user, userId);
    }

    public boolean isSameUser(String userId) {
        return this.user().getId().equals(userId);
    }

    public boolean hasAccessToAccountByPaymentId(String paymentId) {
        return this.hasAccessToAccount(this.getAccountIdFromPayment(paymentId));
    }

    public boolean hasAccessToAccountsWithIbans(Collection<String> ibans) {
        UserTO user = this.user();
        return user.getUserRoles().contains(UserRoleTO.SYSTEM) || user.getUserRoles().contains(UserRoleTO.STAFF) && user.hasAccessToAccountsWithIbans(ibans) || user.hasAccessToAccountsWithIbans(ibans) && ibans.stream().allMatch(this::isEnabledAccountIban);
    }

    public boolean hasAccessToAccount(String accountId) {
        UserTO user = this.user();
        return user.getUserRoles().contains(UserRoleTO.SYSTEM) || user.getUserRoles().contains(UserRoleTO.STAFF) && user.hasAccessToAccountWithId(accountId) || user.hasAccessToAccountWithId(accountId) && this.isEnabledAccount(accountId);
    }

    public boolean hasAccessToAccountWithIban(String iban) {
        UserTO user = this.user();
        return user.getUserRoles().contains(UserRoleTO.SYSTEM) || user.getUserRoles().contains(UserRoleTO.STAFF) && user.hasAccessToAccountWithIban(iban) || user.hasAccessToAccountWithIban(iban) && this.isEnabledAccountIban(iban);
    }

    public boolean accountInfoByIdentifier(AccountIdentifierTypeTO type, String accountIdentifier) {
        return type == AccountIdentifierTypeTO.IBAN ? this.hasAccessToAccountWithIban(accountIdentifier) : this.hasAccessToAccount(accountIdentifier);
    }

    public boolean isEnabledAccount(String accountId) {
        return this.accountService.getDepositAccountById(accountId, LocalDateTime.now(), false).isEnabled();
    }

    public boolean hasAccessToAccountByLogin(String login, String iban) {
        return this.userManagementService.findByUserLogin(login).hasAccessToAccountWithIban(iban);
    }

    public boolean hasAccessToAccountsByLogin(String login, List<AccountReferenceTO> references) {
        Set ibans = references.stream().map(AccountReferenceTO::getIban).collect(Collectors.toSet());
        return this.userManagementService.findByUserLogin(login).hasAccessToAccountsWithIbans(ibans);
    }

    public boolean isEnabledUser(String userId) {
        return this.userManagementService.findById(userId).isEnabled();
    }

    public boolean hasScaScope() {
        return this.hasAnyScope("sca", "partial_access", "full_access");
    }

    public boolean hasPartialScope() {
        return this.hasAnyScope("partial_access", "full_access");
    }

    public boolean hasAccessToAccountByScaOperation(StartScaOprTO opr) {
        return EnumSet.of(OpTypeTO.PAYMENT, OpTypeTO.CANCEL_PAYMENT).contains(opr.getOpType()) ? this.hasAccessToAccountByPaymentId(opr.getOprId()) : this.hasAccessToAccountsWithIbans(this.accountService.getAccountsFromConsent(opr.getOprId()));
    }

    public boolean hasAccessToAccountByAuthorizationId(String authorizationId) {
        return this.hasAccessToAccountByScaOperation(this.scaService.loadScaInformation(authorizationId));
    }

    private AccessTokenTO getAccessTokenTO() {
        RefreshableKeycloakSecurityContext credentials = (RefreshableKeycloakSecurityContext)this.authentication.getCredentials();
        return this.authMapper.toAccessToken(credentials);
    }

    private UserTO user() {
        return this.userManagementService.findByUserLogin(this.getAccessTokenTO().getLogin());
    }

    private boolean hasAnyScope(String ... scopes) {
        Set<String> scopesInToken = this.getScopes();
        return Arrays.stream(scopes).anyMatch(scopesInToken::contains);
    }

    private Set<String> getScopes() {
        RefreshableKeycloakSecurityContext credentials = (RefreshableKeycloakSecurityContext)this.authentication.getCredentials();
        return new HashSet<String>(Arrays.asList(credentials.getToken().getScope().split(" ")));
    }

    private boolean isEnabledAccountIban(String iban) {
        return this.accountService.getAccountsByIbanAndCurrency(iban, "").stream().allMatch(AccountDetailsTO::isEnabled);
    }

    private String getAccountIdFromPayment(String paymentId) {
        return this.paymentService.getPaymentById(paymentId).getAccountId();
    }

    private boolean hasAccessToUser(UserTO initiator, String userId) {
        return !initiator.getUserRoles().contains(UserRoleTO.STAFF) || this.userManagementService.findById(userId).getBranch().equals(initiator.getId());
    }

    private boolean hasManagerAccessIban(String iban, UserTO user) {
        return user.getUserRoles().contains(UserRoleTO.SYSTEM) || user.hasAccessToAccountWithIban(iban);
    }

    private boolean hasManagerAccessId(String accountId, UserTO user) {
        return user.getUserRoles().contains(UserRoleTO.SYSTEM) || user.hasAccessToAccountWithId(accountId);
    }
}

