/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.resource;

import de.adorsys.ledgers.deposit.api.domain.MockBookingDetailsBO;
import de.adorsys.ledgers.deposit.api.service.TransactionService;
import de.adorsys.ledgers.middleware.api.domain.account.MockBookingDetails;
import de.adorsys.ledgers.middleware.rest.annotation.MiddlewareUserResource;
import de.adorsys.ledgers.middleware.rest.mapper.MockTransactionMapper;
import de.adorsys.ledgers.middleware.rest.resource.TransactionsStaffResourceAPI;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@MiddlewareUserResource
@RequestMapping(value={"/staff-access/transactions"})
public class TransactionsStaffResource
implements TransactionsStaffResourceAPI {
    private final TransactionService transactionService;
    private final MockTransactionMapper transactionMapper;

    @PreAuthorize(value="hasRole('STAFF')")
    public ResponseEntity<Map<String, String>> transactions(List<MockBookingDetails> data) {
        List<MockBookingDetailsBO> dataBO = this.transactionMapper.toMockTransactionDetailsBO(data);
        return new ResponseEntity((Object)this.transactionService.bookMockTransaction(dataBO), HttpStatus.CREATED);
    }

    public TransactionsStaffResource(TransactionService transactionService, MockTransactionMapper transactionMapper) {
        this.transactionService = transactionService;
        this.transactionMapper = transactionMapper;
    }
}

