/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.resource;

import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTypeTO;
import de.adorsys.ledgers.middleware.api.domain.payment.TransactionStatusTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAPaymentResponseTO;
import de.adorsys.ledgers.middleware.api.service.MiddlewarePaymentService;
import de.adorsys.ledgers.middleware.rest.annotation.MiddlewareUserResource;
import de.adorsys.ledgers.middleware.rest.resource.PaymentRestAPI;
import de.adorsys.ledgers.middleware.rest.security.ScaInfoHolder;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@MiddlewareUserResource
@RequestMapping(value={"/payments"})
public class PaymentResource
implements PaymentRestAPI {
    private static final Logger log = LoggerFactory.getLogger(PaymentResource.class);
    private final MiddlewarePaymentService paymentService;
    private final ScaInfoHolder scaInfoHolder;

    @PreAuthorize(value="hasAccessToAccountByPaymentId(#paymentId)")
    public ResponseEntity<TransactionStatusTO> getPaymentStatusById(String paymentId) {
        return ResponseEntity.ok((Object)this.paymentService.getPaymentStatusById(paymentId));
    }

    @PreAuthorize(value="hasAccessToAccountByPaymentId(#paymentId)")
    public ResponseEntity<PaymentTO> getPaymentById(String paymentId) {
        return ResponseEntity.ok((Object)this.paymentService.getPaymentById(paymentId));
    }

    @PreAuthorize(value="hasRole('CUSTOMER')")
    public ResponseEntity<List<PaymentTO>> getPendingPeriodicPayments() {
        return ResponseEntity.ok((Object)this.paymentService.getPendingPeriodicPayments(this.scaInfoHolder.getScaInfo()));
    }

    @PreAuthorize(value="hasAccessToAccountWithIban(#payment.debtorAccount.iban)")
    public ResponseEntity<SCAPaymentResponseTO> initiatePayment(PaymentTypeTO paymentType, PaymentTO payment) {
        return new ResponseEntity((Object)this.paymentService.initiatePayment(this.scaInfoHolder.getScaInfo(), payment, paymentType), HttpStatus.CREATED);
    }

    @PreAuthorize(value="hasPartialScope() and hasAccessToAccountByPaymentId(#paymentId)")
    public ResponseEntity<SCAPaymentResponseTO> executePayment(String paymentId) {
        return ResponseEntity.accepted().body((Object)this.paymentService.executePayment(this.scaInfoHolder.getScaInfo(), paymentId));
    }

    @PreAuthorize(value="hasAccessToAccountByPaymentId(#paymentId)")
    public ResponseEntity<SCAPaymentResponseTO> initiatePmtCancellation(String paymentId) {
        return ResponseEntity.ok((Object)this.paymentService.initiatePaymentCancellation(this.scaInfoHolder.getScaInfo(), paymentId));
    }

    @PreAuthorize(value="hasPartialScope() and hasAccessToAccountByPaymentId(#paymentId)")
    public ResponseEntity<SCAPaymentResponseTO> executeCancelPayment(String paymentId) {
        return ResponseEntity.ok((Object)this.paymentService.authorizeCancelPayment(this.scaInfoHolder.getScaInfo(), paymentId));
    }

    public PaymentResource(MiddlewarePaymentService paymentService, ScaInfoHolder scaInfoHolder) {
        this.paymentService = paymentService;
        this.scaInfoHolder = scaInfoHolder;
    }
}

