/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.resource;

import de.adorsys.ledgers.middleware.api.domain.general.BbanStructure;
import de.adorsys.ledgers.middleware.api.domain.general.RecoveryPointTO;
import de.adorsys.ledgers.middleware.api.domain.um.UploadedDataTO;
import de.adorsys.ledgers.middleware.api.service.AppManagementService;
import de.adorsys.ledgers.middleware.api.service.CurrencyService;
import de.adorsys.ledgers.middleware.api.service.MiddlewareAccountManagementService;
import de.adorsys.ledgers.middleware.api.service.MiddlewareRecoveryService;
import de.adorsys.ledgers.middleware.rest.annotation.MiddlewareResetResource;
import de.adorsys.ledgers.middleware.rest.resource.DataMgmtStaffAPI;
import de.adorsys.ledgers.middleware.rest.security.ScaInfoHolder;
import java.util.Currency;
import java.util.List;
import java.util.Set;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@MiddlewareResetResource
@RequestMapping(value={"/staff-access/data"})
public class DataMgmtStaffResource
implements DataMgmtStaffAPI {
    private final ScaInfoHolder scaInfoHolder;
    private final MiddlewareAccountManagementService accountManagementService;
    private final AppManagementService appManagementService;
    private final CurrencyService currencyService;
    private final MiddlewareRecoveryService recoveryService;

    @PreAuthorize(value="hasManagerAccessToAccountId(#accountId)")
    public ResponseEntity<Void> account(String accountId) {
        this.accountManagementService.deleteTransactions(this.scaInfoHolder.getUserId(), this.scaInfoHolder.getScaInfo().getUserRole(), accountId);
        return ResponseEntity.ok().build();
    }

    @PreAuthorize(value="hasManagerAccessToAccountId(#accountId)")
    public ResponseEntity<Void> depositAccount(String accountId) {
        this.accountManagementService.deleteAccount(this.scaInfoHolder.getUserId(), this.scaInfoHolder.getScaInfo().getUserRole(), accountId);
        return ResponseEntity.ok().build();
    }

    @PreAuthorize(value="hasManagerAccessToUser(#userId)")
    public ResponseEntity<Void> user(String userId) {
        this.accountManagementService.deleteUser(this.scaInfoHolder.getUserId(), this.scaInfoHolder.getScaInfo().getUserRole(), userId);
        return ResponseEntity.ok().build();
    }

    @PreAuthorize(value="hasManagerAccessToUser(#branchId)")
    public ResponseEntity<Void> branch(String branchId) {
        this.appManagementService.removeBranch(this.scaInfoHolder.getUserId(), this.scaInfoHolder.getScaInfo().getUserRole(), branchId);
        return ResponseEntity.ok().build();
    }

    @PreAuthorize(value="hasAnyRole('STAFF','SYSTEM')")
    public ResponseEntity<Void> uploadData(UploadedDataTO data) {
        this.appManagementService.uploadData(data, this.scaInfoHolder.getScaInfo());
        return ResponseEntity.ok().build();
    }

    @PreAuthorize(value="hasAnyRole('STAFF','SYSTEM')")
    public ResponseEntity<Set<Currency>> currencies() {
        return ResponseEntity.ok((Object)this.currencyService.getSupportedCurrencies());
    }

    public ResponseEntity<String> branchId(BbanStructure bbanStructure) {
        return ResponseEntity.ok((Object)this.appManagementService.generateNextBban(bbanStructure));
    }

    @PreAuthorize(value="hasRole('STAFF')")
    public ResponseEntity<Void> createPoint(RecoveryPointTO recoveryPoint) {
        this.recoveryService.createRecoveryPoint(this.scaInfoHolder.getUserId(), recoveryPoint);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).build();
    }

    @PreAuthorize(value="hasRole('STAFF')")
    public ResponseEntity<List<RecoveryPointTO>> getAllPoints() {
        return ResponseEntity.ok((Object)this.recoveryService.getAll(this.scaInfoHolder.getUserId()));
    }

    @PreAuthorize(value="hasRole('STAFF')")
    public ResponseEntity<RecoveryPointTO> getPoint(Long id) {
        return ResponseEntity.ok((Object)this.recoveryService.getPointById(this.scaInfoHolder.getUserId(), id));
    }

    @PreAuthorize(value="hasRole('STAFF')")
    public ResponseEntity<Void> deletePoint(Long id) {
        this.recoveryService.deleteById(this.scaInfoHolder.getUserId(), id);
        return ResponseEntity.status((HttpStatus)HttpStatus.NO_CONTENT).build();
    }

    public DataMgmtStaffResource(ScaInfoHolder scaInfoHolder, MiddlewareAccountManagementService accountManagementService, AppManagementService appManagementService, CurrencyService currencyService, MiddlewareRecoveryService recoveryService) {
        this.scaInfoHolder = scaInfoHolder;
        this.accountManagementService = accountManagementService;
        this.appManagementService = appManagementService;
        this.currencyService = currencyService;
        this.recoveryService = recoveryService;
    }
}

