/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.resource;

import de.adorsys.ledgers.middleware.api.domain.account.AccountDetailsExtendedTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserExtendedTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserRoleTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.ledgers.middleware.api.exception.MiddlewareErrorCode;
import de.adorsys.ledgers.middleware.api.exception.MiddlewareModuleException;
import de.adorsys.ledgers.middleware.api.service.AppManagementService;
import de.adorsys.ledgers.middleware.api.service.MiddlewareAccountManagementService;
import de.adorsys.ledgers.middleware.api.service.MiddlewareUserManagementService;
import de.adorsys.ledgers.middleware.impl.converter.UserMapper;
import de.adorsys.ledgers.middleware.rest.annotation.MiddlewareResetResource;
import de.adorsys.ledgers.middleware.rest.resource.AdminResourceAPI;
import de.adorsys.ledgers.um.api.domain.UserBO;
import de.adorsys.ledgers.um.api.service.UserService;
import de.adorsys.ledgers.util.domain.CustomPageImpl;
import de.adorsys.ledgers.util.domain.CustomPageableImpl;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@MiddlewareResetResource
@RequestMapping(value={"/admin"})
public class AdminResource
implements AdminResourceAPI {
    private final MiddlewareUserManagementService middlewareUserService;
    private final MiddlewareAccountManagementService accountManagementService;
    private final AppManagementService appManagementService;
    private final UserService userService;
    private final UserMapper userMapper;

    @PreAuthorize(value="hasRole('SYSTEM')")
    public ResponseEntity<CustomPageImpl<UserExtendedTO>> users(String countryCode, String branchId, String branchLogin, String userLogin, UserRoleTO role, Boolean blocked, int page, int size) {
        CustomPageableImpl pageable = new CustomPageableImpl(page, size);
        List roles = Optional.ofNullable(role).map(Collections::singletonList).orElseGet(() -> Arrays.asList(UserRoleTO.STAFF, UserRoleTO.CUSTOMER));
        return ResponseEntity.ok((Object)this.middlewareUserService.getUsersByBranchAndRolesExtended(countryCode, branchId, branchLogin, userLogin, roles, blocked, pageable));
    }

    @PreAuthorize(value="hasRole('SYSTEM')")
    public ResponseEntity<CustomPageImpl<UserTO>> admins(int page, int size) {
        CustomPageableImpl pageable = new CustomPageableImpl(page, size);
        return ResponseEntity.ok((Object)this.middlewareUserService.getUsersByRoles(Collections.singletonList(UserRoleTO.SYSTEM), pageable));
    }

    @PreAuthorize(value="hasRole('SYSTEM')")
    public ResponseEntity<CustomPageImpl<AccountDetailsExtendedTO>> accounts(String countryCode, String branchId, String branchLogin, String iban, Boolean blocked, int page, int size) {
        CustomPageableImpl pageable = new CustomPageableImpl(page, size);
        return ResponseEntity.ok((Object)this.accountManagementService.getAccountsByBranchAndMultipleParams(countryCode, branchId, branchLogin, iban, blocked, pageable));
    }

    @PreAuthorize(value="hasRole('SYSTEM')")
    public ResponseEntity<Void> updatePassword(String branchId, String password) {
        this.middlewareUserService.updatePassword(branchId, password);
        return ResponseEntity.accepted().build();
    }

    @PreAuthorize(value="hasRole('SYSTEM')")
    public ResponseEntity<Boolean> changeStatus(String userId) {
        return ResponseEntity.ok((Object)this.appManagementService.changeBlockedStatus(userId, false));
    }

    @PreAuthorize(value="hasRole('SYSTEM')")
    public ResponseEntity<UserTO> register(UserTO user) {
        UserTO createdUser = this.middlewareUserService.create(user);
        createdUser.setPin(null);
        return ResponseEntity.ok((Object)createdUser);
    }

    @PreAuthorize(value="hasRole('SYSTEM') and isEnabledUser(#user.id)")
    public ResponseEntity<Void> user(UserTO user) {
        this.checkUpdateData(user);
        this.middlewareUserService.updateUser(user.getBranch(), user);
        return ResponseEntity.accepted().build();
    }

    private void checkUpdateData(UserTO user) {
        UserBO userStored = this.userService.findById(user.getId());
        if (!userStored.getUserRoles().containsAll(this.userMapper.toUserBO(user).getUserRoles())) {
            throw MiddlewareModuleException.builder().errorCode(MiddlewareErrorCode.INSUFFICIENT_PERMISSION).devMsg("You are not allowed to modify users roles!").build();
        }
        if (!StringUtils.equals((CharSequence)userStored.getBranch(), (CharSequence)user.getBranch()) || user.getUserRoles().contains(UserRoleTO.STAFF) && !StringUtils.equals((CharSequence)user.getBranch(), (CharSequence)user.getId()) || !StringUtils.equals((CharSequence)user.getId(), (CharSequence)userStored.getId())) {
            throw MiddlewareModuleException.builder().errorCode(MiddlewareErrorCode.INSUFFICIENT_PERMISSION).devMsg("User are not allowed to modify users TPP relation!").build();
        }
    }

    public AdminResource(MiddlewareUserManagementService middlewareUserService, MiddlewareAccountManagementService accountManagementService, AppManagementService appManagementService, UserService userService, UserMapper userMapper) {
        this.middlewareUserService = middlewareUserService;
        this.accountManagementService = accountManagementService;
        this.appManagementService = appManagementService;
        this.userService = userService;
        this.userMapper = userMapper;
    }
}

