/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.resource;

import de.adorsys.ledgers.middleware.api.domain.sca.GlobalScaResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaLoginOprTO;
import de.adorsys.ledgers.middleware.api.service.MiddlewareScaService;
import de.adorsys.ledgers.middleware.rest.annotation.MiddlewareUserResource;
import de.adorsys.ledgers.middleware.rest.resource.RedirectScaRestAPI;
import de.adorsys.ledgers.middleware.rest.security.ScaInfoHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sca"})
@MiddlewareUserResource
public class RedirectScaResource
implements RedirectScaRestAPI {
    private static final Logger log = LoggerFactory.getLogger(RedirectScaResource.class);
    private final ScaInfoHolder scaInfoHolder;
    private final MiddlewareScaService scaService;

    public ResponseEntity<GlobalScaResponseTO> authoriseForConsent(ScaLoginOprTO loginOpr) {
        return ResponseEntity.ok((Object)this.scaService.loginForOperation(loginOpr));
    }

    public ResponseEntity<GlobalScaResponseTO> getSCA(String authorisationId) {
        return ResponseEntity.ok((Object)this.scaService.getMethods(authorisationId, this.scaInfoHolder.getUserId()));
    }

    public ResponseEntity<GlobalScaResponseTO> selectMethod(String authorisationId, String scaMethodId) {
        return ResponseEntity.ok((Object)this.scaService.selectMethod(this.scaInfoHolder.getScaInfoWithScaMethodIdAndAuthorisationId(scaMethodId, authorisationId)));
    }

    public ResponseEntity<GlobalScaResponseTO> authorize(String authorisationId, String authCode) {
        return ResponseEntity.ok((Object)this.scaService.confirmAuthorization(this.scaInfoHolder.getScaInfoWithAuthCode(authCode)));
    }

    public RedirectScaResource(ScaInfoHolder scaInfoHolder, MiddlewareScaService scaService) {
        this.scaInfoHolder = scaInfoHolder;
        this.scaService = scaService;
    }
}

