/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.security;

import de.adorsys.ledgers.middleware.api.domain.sca.ScaInfoTO;
import de.adorsys.ledgers.middleware.api.domain.um.AccessTokenTO;
import de.adorsys.ledgers.middleware.api.domain.um.TokenUsageTO;
import de.adorsys.ledgers.middleware.rest.security.ScaInfoHolder;
import org.springframework.stereotype.Component;

@Component
public class ScaInfoHolderImpl
implements ScaInfoHolder {
    private final AccessTokenTO accessTokenTO;

    @Override
    public String getUserId() {
        return this.accessTokenTO.getSub();
    }

    @Override
    public TokenUsageTO getTokenUsageTO() {
        return this.accessTokenTO.getTokenUsage();
    }

    @Override
    public ScaInfoTO getScaInfo() {
        return this.buildScaInfo();
    }

    @Override
    public ScaInfoTO getScaInfoWithScaMethodIdAndAuthorisationId(String scaMethodId, String authorizationId) {
        ScaInfoTO info = this.buildScaInfo();
        info.setScaMethodId(scaMethodId);
        info.setAuthorisationId(authorizationId);
        return info;
    }

    @Override
    public ScaInfoTO getScaInfoWithAuthCode(String authCode) {
        ScaInfoTO info = this.buildScaInfo();
        info.setAuthCode(authCode);
        return info;
    }

    private ScaInfoTO buildScaInfo() {
        ScaInfoTO info = new ScaInfoTO();
        info.setUserId(this.accessTokenTO.getSub());
        info.setAuthorisationId(this.accessTokenTO.getAuthorisationId());
        info.setScaId(this.accessTokenTO.getScaId());
        info.setUserRole(this.accessTokenTO.getRole());
        info.setUserLogin(this.accessTokenTO.getLogin());
        return info;
    }

    public ScaInfoHolderImpl(AccessTokenTO accessTokenTO) {
        this.accessTokenTO = accessTokenTO;
    }
}

