/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.resource;

import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTypeTO;
import de.adorsys.ledgers.middleware.api.domain.payment.TransactionStatusTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAPaymentResponseTO;
import de.adorsys.ledgers.middleware.api.service.MiddlewarePaymentService;
import de.adorsys.ledgers.middleware.rest.annotation.MiddlewareUserResource;
import de.adorsys.ledgers.middleware.rest.resource.PaymentRestAPI;
import de.adorsys.ledgers.middleware.rest.security.ScaInfoHolder;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@MiddlewareUserResource
@RequestMapping(value={"/payments"})
public class PaymentResource
implements PaymentRestAPI {
    private static final Logger log = LoggerFactory.getLogger(PaymentResource.class);
    private final MiddlewarePaymentService paymentService;
    private final ScaInfoHolder scaInfoHolder;

    @PreAuthorize(value="paymentInfoById(#paymentId)")
    public ResponseEntity<TransactionStatusTO> getPaymentStatusById(String paymentId) {
        return ResponseEntity.ok((Object)this.paymentService.getPaymentStatusById(paymentId));
    }

    @PreAuthorize(value="paymentInfoById(#paymentId)")
    public ResponseEntity<PaymentTO> getPaymentById(String paymentId) {
        return ResponseEntity.ok((Object)this.paymentService.getPaymentById(paymentId));
    }

    public ResponseEntity<List<PaymentTO>> getPendingPeriodicPayments() {
        return ResponseEntity.ok((Object)this.paymentService.getPendingPeriodicPayments(this.scaInfoHolder.getScaInfo()));
    }

    public ResponseEntity<SCAPaymentResponseTO> initiatePayment(PaymentTypeTO paymentType, PaymentTO payment) {
        return new ResponseEntity((Object)this.paymentService.initiatePayment(this.scaInfoHolder.getScaInfo(), payment, paymentType), HttpStatus.CREATED);
    }

    public ResponseEntity<SCAPaymentResponseTO> executePayment(PaymentTO payment) {
        return ResponseEntity.accepted().body((Object)this.paymentService.executePayment(this.scaInfoHolder.getScaInfo(), payment));
    }

    @PreAuthorize(value="paymentInfoById(#paymentId)")
    public ResponseEntity<SCAPaymentResponseTO> getSCA(String paymentId, String authorisationId) {
        return ResponseEntity.ok((Object)this.paymentService.loadSCAForPaymentData(this.scaInfoHolder.getScaInfo(), paymentId));
    }

    @PreAuthorize(value="paymentInfoById(#paymentId)")
    public ResponseEntity<SCAPaymentResponseTO> selectMethod(String paymentId, String authorisationId, String scaMethodId) {
        return ResponseEntity.ok((Object)this.paymentService.selectSCAMethodForPayment(this.scaInfoHolder.getScaInfoWithScaMethodIdAndAuthorisationId(scaMethodId, authorisationId), paymentId));
    }

    @PreAuthorize(value="paymentInfoById(#paymentId)")
    public ResponseEntity<SCAPaymentResponseTO> authorizePayment(String paymentId, String authorisationId, String authCode) {
        return ResponseEntity.ok((Object)this.paymentService.authorizePayment(this.scaInfoHolder.getScaInfoWithAuthCode(authCode), paymentId));
    }

    @PreAuthorize(value="paymentInitById(#paymentId)")
    public ResponseEntity<SCAPaymentResponseTO> initiatePmtCancellation(String paymentId) {
        return ResponseEntity.ok((Object)this.paymentService.initiatePaymentCancellation(this.scaInfoHolder.getScaInfo(), paymentId));
    }

    @PreAuthorize(value="paymentInfoById(#paymentId)")
    public ResponseEntity<SCAPaymentResponseTO> getCancelSCA(String paymentId, String cancellationId) {
        return ResponseEntity.ok((Object)this.paymentService.loadSCAForCancelPaymentData(this.scaInfoHolder.getScaInfo(), paymentId, cancellationId));
    }

    @PreAuthorize(value="paymentInfoById(#paymentId)")
    public ResponseEntity<SCAPaymentResponseTO> selecCancelPaymentSCAtMethod(String paymentId, String cancellationId, String scaMethodId) {
        return ResponseEntity.ok((Object)this.paymentService.selectSCAMethodForCancelPayment(this.scaInfoHolder.getScaInfoWithScaMethodIdAndAuthorisationId(scaMethodId, cancellationId), paymentId, cancellationId));
    }

    @PreAuthorize(value="paymentInfoById(#paymentId)")
    public ResponseEntity<SCAPaymentResponseTO> authorizeCancelPayment(String paymentId, String cancellationId, String authCode) {
        return ResponseEntity.ok((Object)this.paymentService.authorizeCancelPayment(this.scaInfoHolder.getScaInfoWithAuthCode(authCode), paymentId, cancellationId));
    }

    public PaymentResource(MiddlewarePaymentService paymentService, ScaInfoHolder scaInfoHolder) {
        this.paymentService = paymentService;
        this.scaInfoHolder = scaInfoHolder;
    }
}

