/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.resource;

import de.adorsys.ledgers.middleware.api.domain.sca.SCAConsentResponseTO;
import de.adorsys.ledgers.middleware.api.domain.um.AisConsentTO;
import de.adorsys.ledgers.middleware.api.service.MiddlewareAccountManagementService;
import de.adorsys.ledgers.middleware.rest.annotation.MiddlewareUserResource;
import de.adorsys.ledgers.middleware.rest.resource.ConsentRestAPI;
import de.adorsys.ledgers.middleware.rest.security.ScaInfoHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/consents"})
@MiddlewareUserResource
public class ConsentResource
implements ConsentRestAPI {
    private static final Logger log = LoggerFactory.getLogger(ConsentResource.class);
    private final ScaInfoHolder scaInfoHolder;
    private final MiddlewareAccountManagementService middlewareAccountService;

    public ResponseEntity<SCAConsentResponseTO> startSCA(String consentId, AisConsentTO aisConsent) {
        return ResponseEntity.ok((Object)this.middlewareAccountService.startSCA(this.scaInfoHolder.getScaInfo(), consentId, aisConsent));
    }

    public ResponseEntity<SCAConsentResponseTO> getSCA(String consentId, String authorisationId) {
        return ResponseEntity.ok((Object)this.middlewareAccountService.loadSCAForAisConsent(this.scaInfoHolder.getUserId(), consentId, authorisationId));
    }

    public ResponseEntity<SCAConsentResponseTO> selectMethod(String consentId, String authorisationId, String scaMethodId) {
        return ResponseEntity.ok((Object)this.middlewareAccountService.selectSCAMethodForAisConsent(this.scaInfoHolder.getUserId(), consentId, authorisationId, scaMethodId));
    }

    public ResponseEntity<SCAConsentResponseTO> authorizeConsent(String consentId, String authorisationId, String authCode) {
        return ResponseEntity.ok((Object)this.middlewareAccountService.authorizeConsent(this.scaInfoHolder.getScaInfoWithAuthCode(authCode), consentId));
    }

    @PreAuthorize(value="tokenUsage('DIRECT_ACCESS') and accountInfoFor(#aisConsent)")
    public ResponseEntity<SCAConsentResponseTO> grantPIISConsent(AisConsentTO aisConsent) {
        return ResponseEntity.ok((Object)this.middlewareAccountService.grantAisConsent(this.scaInfoHolder.getScaInfo(), aisConsent));
    }

    public ConsentResource(ScaInfoHolder scaInfoHolder, MiddlewareAccountManagementService middlewareAccountService) {
        this.scaInfoHolder = scaInfoHolder;
        this.middlewareAccountService = middlewareAccountService;
    }
}

