/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.resource;

import de.adorsys.ledgers.middleware.api.service.EmailVerificationService;
import de.adorsys.ledgers.middleware.rest.annotation.MiddlewareUserResource;
import de.adorsys.ledgers.middleware.rest.resource.ScaVerificationRestAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/emails"})
@MiddlewareUserResource
public class ScaVerificationResource
implements ScaVerificationRestAPI {
    private static final Logger log = LoggerFactory.getLogger(ScaVerificationResource.class);
    private final EmailVerificationService emailVerificationService;

    @PreAuthorize(value="tokenUsage('DIRECT_ACCESS')")
    public ResponseEntity<Void> sendEmailVerification(String email) {
        String token = this.emailVerificationService.createVerificationToken(email);
        this.emailVerificationService.sendVerificationEmail(token);
        return ResponseEntity.ok().build();
    }

    public ResponseEntity<Void> confirmVerificationToken(String token) {
        this.emailVerificationService.confirmUser(token);
        return ResponseEntity.ok().build();
    }

    public ScaVerificationResource(EmailVerificationService emailVerificationService) {
        this.emailVerificationService = emailVerificationService;
    }
}

