/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.resource;

import de.adorsys.ledgers.middleware.api.domain.sca.SCALoginResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaInfoTO;
import de.adorsys.ledgers.middleware.api.domain.um.AccountAccessTO;
import de.adorsys.ledgers.middleware.api.domain.um.ScaUserDataTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserCredentialsTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserRoleTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.ledgers.middleware.api.exception.MiddlewareErrorCode;
import de.adorsys.ledgers.middleware.api.exception.MiddlewareModuleException;
import de.adorsys.ledgers.middleware.api.service.MiddlewareOnlineBankingService;
import de.adorsys.ledgers.middleware.api.service.MiddlewareUserManagementService;
import de.adorsys.ledgers.middleware.impl.converter.PageMapper;
import de.adorsys.ledgers.middleware.rest.annotation.MiddlewareUserResource;
import de.adorsys.ledgers.middleware.rest.resource.UserMgmtStaffResourceAPI;
import de.adorsys.ledgers.middleware.rest.security.ScaInfoHolder;
import de.adorsys.ledgers.util.domain.CustomPageImpl;
import de.adorsys.ledgers.util.domain.CustomPageableImpl;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@MiddlewareUserResource
@RequestMapping(value={"/staff-access/users"})
public class UserMgmtStaffResource
implements UserMgmtStaffResourceAPI {
    private final MiddlewareOnlineBankingService onlineBankingService;
    private final MiddlewareUserManagementService middlewareUserService;
    private final ScaInfoHolder scaInfoHolder;
    private final PageMapper pageMapper;

    public ResponseEntity<UserTO> register(String branch, UserTO branchStaff) {
        if (this.middlewareUserService.countUsersByBranch(branch) > 0) {
            throw MiddlewareModuleException.builder().errorCode(MiddlewareErrorCode.INSUFFICIENT_PERMISSION).devMsg("User cannot register for this branch. The branch is occupied by other user").build();
        }
        branchStaff.setBranch(branch);
        branchStaff.setUserRoles(Collections.singletonList(UserRoleTO.STAFF));
        UserTO user = this.middlewareUserService.create(branchStaff);
        user.setPin(null);
        return ResponseEntity.ok((Object)user);
    }

    public ResponseEntity<UserTO> modifyUser(String branch, UserTO user) {
        return ResponseEntity.ok((Object)this.middlewareUserService.updateUser(branch, user));
    }

    public ResponseEntity<SCALoginResponseTO> login(UserCredentialsTO userCredentials) {
        return ResponseEntity.ok((Object)this.onlineBankingService.authorise(userCredentials.getLogin(), userCredentials.getPin(), UserRoleTO.STAFF));
    }

    @PreAuthorize(value="hasRole('STAFF')")
    public ResponseEntity<UserTO> createUser(UserTO user) {
        UserTO branchStaff = this.middlewareUserService.findById(this.scaInfoHolder.getScaInfo().getUserId());
        user.setBranch(branchStaff.getBranch());
        user.getUserRoles().remove(UserRoleTO.SYSTEM);
        user.getUserRoles().remove(UserRoleTO.TECHNICAL);
        UserTO newUser = this.middlewareUserService.create(user);
        newUser.setPin(null);
        return ResponseEntity.ok((Object)newUser);
    }

    @PreAuthorize(value="hasRole('STAFF')")
    public ResponseEntity<CustomPageImpl<UserTO>> getBranchUsersByRoles(List<UserRoleTO> roles, String queryParam, int page, int size) {
        CustomPageableImpl pageable = new CustomPageableImpl(page, size);
        UserTO branchStaff = this.middlewareUserService.findById(this.scaInfoHolder.getScaInfo().getUserId());
        CustomPageImpl users = this.middlewareUserService.getUsersByBranchAndRoles(branchStaff.getBranch(), roles, queryParam, pageable);
        return ResponseEntity.ok((Object)users);
    }

    @PreAuthorize(value="hasRole('STAFF')")
    public ResponseEntity<UserTO> getBranchUserById(String userId) {
        UserTO user = this.findUserForBranch(userId);
        return ResponseEntity.ok((Object)user);
    }

    @PreAuthorize(value="hasRole('STAFF')")
    public ResponseEntity<Void> updateUserScaData(String userId, List<ScaUserDataTO> data) {
        UserTO user = this.findUserForBranch(userId);
        UserTO userWithUpdatedSca = this.middlewareUserService.updateScaData(user.getLogin(), data);
        URI uri = UriComponentsBuilder.fromUriString((String)("/staff-access/users/" + userWithUpdatedSca.getId())).build().toUri();
        return ResponseEntity.created((URI)uri).build();
    }

    @PreAuthorize(value="hasRole('STAFF')")
    public ResponseEntity<Void> updateAccountAccessForUser(String userId, AccountAccessTO access) {
        ScaInfoTO scaInfo = this.scaInfoHolder.getScaInfo();
        this.middlewareUserService.updateAccountAccess(scaInfo, userId, access);
        return new ResponseEntity(HttpStatus.OK);
    }

    private UserTO findUserForBranch(String userId) {
        UserTO branchStaff = this.middlewareUserService.findById(this.scaInfoHolder.getScaInfo().getUserId());
        UserTO user = this.middlewareUserService.findById(userId);
        if (!branchStaff.getBranch().equals(user.getBranch())) {
            throw MiddlewareModuleException.builder().errorCode(MiddlewareErrorCode.INSUFFICIENT_PERMISSION).devMsg("User is not your branch").build();
        }
        return user;
    }

    public UserMgmtStaffResource(MiddlewareOnlineBankingService onlineBankingService, MiddlewareUserManagementService middlewareUserService, ScaInfoHolder scaInfoHolder, PageMapper pageMapper) {
        this.onlineBankingService = onlineBankingService;
        this.middlewareUserService = middlewareUserService;
        this.scaInfoHolder = scaInfoHolder;
        this.pageMapper = pageMapper;
    }
}

