/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.security;

import de.adorsys.ledgers.middleware.api.domain.um.AccessTokenTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserRoleTO;
import de.adorsys.ledgers.middleware.api.service.MiddlewareOnlineBankingService;
import de.adorsys.ledgers.middleware.rest.security.MiddlewareAuthentication;
import de.adorsys.ledgers.util.exception.UserManagementModuleException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.stereotype.Service;

@Service
public class TokenAuthenticationService {
    private static final Logger log = LoggerFactory.getLogger(TokenAuthenticationService.class);
    private static final String TOKEN_PREFIX = "Bearer ";
    private static final String HEADER_KEY = "Authorization";
    private final MiddlewareOnlineBankingService onlineBankingService;

    public Authentication getAuthentication(HttpServletRequest request) {
        BearerTokenTO bearerToken;
        String headerValue = request.getHeader(HEADER_KEY);
        if (StringUtils.isBlank((CharSequence)headerValue)) {
            this.debug(String.format("Header value '%s' is blank.", HEADER_KEY));
            return null;
        }
        if (!StringUtils.startsWithIgnoreCase((CharSequence)headerValue, (CharSequence)TOKEN_PREFIX)) {
            this.debug(String.format("Header value does not start with '%s'.", TOKEN_PREFIX));
            return null;
        }
        String accessToken = StringUtils.substringAfterLast((String)headerValue, (String)" ");
        try {
            bearerToken = this.onlineBankingService.validate(accessToken);
        }
        catch (UserManagementModuleException e) {
            this.debug("User with token not found.", e);
            return null;
        }
        if (bearerToken == null) {
            this.debug("Token is not valid.");
            return null;
        }
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
        AccessTokenTO accessTokenTO = bearerToken.getAccessTokenObject();
        UserRoleTO role = accessTokenTO.getRole();
        if (role != null) {
            authorities.add(new SimpleGrantedAuthority("ROLE_" + role.name()));
        }
        return new MiddlewareAuthentication(accessTokenTO.getSub(), bearerToken, authorities);
    }

    private void debug(String s) {
        if (log.isDebugEnabled()) {
            log.debug(s);
        }
    }

    private void debug(String s, Throwable e) {
        if (log.isDebugEnabled()) {
            log.debug(s, e);
        }
    }

    public TokenAuthenticationService(MiddlewareOnlineBankingService onlineBankingService) {
        this.onlineBankingService = onlineBankingService;
    }
}

