/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.resource;

import de.adorsys.ledgers.middleware.api.domain.account.AccountReferenceTO;
import de.adorsys.ledgers.middleware.api.domain.sca.OpTypeTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCALoginResponseTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.api.domain.um.ScaUserDataTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserRoleTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTypeTO;
import de.adorsys.ledgers.middleware.api.exception.MiddlewareErrorCode;
import de.adorsys.ledgers.middleware.api.exception.MiddlewareModuleException;
import de.adorsys.ledgers.middleware.api.service.MiddlewareOnlineBankingService;
import de.adorsys.ledgers.middleware.api.service.MiddlewareUserManagementService;
import de.adorsys.ledgers.middleware.rest.annotation.MiddlewareUserResource;
import de.adorsys.ledgers.middleware.rest.resource.UserMgmtRestAPI;
import de.adorsys.ledgers.middleware.rest.security.ScaInfoHolder;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.net.URI;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/users"})
@MiddlewareUserResource
public class UserMgmtResource
implements UserMgmtRestAPI {
    private static final Logger log = LoggerFactory.getLogger(UserMgmtResource.class);
    private final MiddlewareOnlineBankingService onlineBankingService;
    private final MiddlewareUserManagementService middlewareUserService;
    private final ScaInfoHolder scaInfoHolder;

    public ResponseEntity<Boolean> multilevel(String login, String iban) {
        return ResponseEntity.ok((Object)this.middlewareUserService.checkMultilevelScaRequired(login, iban));
    }

    public ResponseEntity<Boolean> multilevelAccounts(String login, List<AccountReferenceTO> references) {
        return ResponseEntity.ok((Object)this.middlewareUserService.checkMultilevelScaRequired(login, references));
    }

    public ResponseEntity<UserTO> register(String login, String email, String pin, UserRoleTO role, UserTypeTO type) {
        UserTO user = this.onlineBankingService.register(login, email, pin, role, type);
        user.setPin(null);
        return ResponseEntity.ok((Object)user);
    }

    public ResponseEntity<SCALoginResponseTO> authorise(String login, String pin, UserRoleTO role) {
        return ResponseEntity.ok((Object)this.onlineBankingService.authorise(login, pin, role));
    }

    public ResponseEntity<SCALoginResponseTO> authoriseForConsent(String login, String pin, String consentId, String authorisationId, OpTypeTO opType) {
        return ResponseEntity.ok((Object)this.onlineBankingService.authoriseForConsent(login, pin, consentId, authorisationId, opType));
    }

    public ResponseEntity<SCALoginResponseTO> authoriseForConsent(String consentId, String authorisationId, OpTypeTO opType) {
        return ResponseEntity.ok((Object)this.onlineBankingService.authoriseForConsentWithToken(this.scaInfoHolder.getScaInfo(), consentId, authorisationId, opType));
    }

    @PreAuthorize(value="loginToken(#scaId,#authorisationId)")
    public ResponseEntity<SCALoginResponseTO> selectMethod(String scaId, String authorisationId, String scaMethodId) {
        return ResponseEntity.ok((Object)this.onlineBankingService.generateLoginAuthCode(this.scaInfoHolder.getScaInfoWithScaMethodIdAndAuthorisationId(scaMethodId, authorisationId), null, 1800));
    }

    @PreAuthorize(value="loginToken(#scaId,#authorisationId)")
    public ResponseEntity<SCALoginResponseTO> authorizeLogin(String scaId, String authorisationId, String authCode) {
        return ResponseEntity.ok((Object)this.onlineBankingService.authenticateForLogin(this.scaInfoHolder.getScaInfoWithAuthCode(authCode)));
    }

    public ResponseEntity<BearerTokenTO> validate(String token) {
        BearerTokenTO tokenTO = this.onlineBankingService.validate(token);
        if (tokenTO != null) {
            return ResponseEntity.ok((Object)tokenTO);
        }
        log.error("Token is null !!!");
        throw MiddlewareModuleException.builder().errorCode(MiddlewareErrorCode.AUTHENTICATION_FAILURE).devMsg("Token invalid").build();
    }

    @PreAuthorize(value="hasAnyRole('STAFF','SYSTEM')")
    public ResponseEntity<UserTO> getUserById(String userId) {
        return ResponseEntity.ok((Object)this.middlewareUserService.findById(userId));
    }

    @PreAuthorize(value="tokenUsage('DIRECT_ACCESS')")
    public ResponseEntity<UserTO> getUser() {
        return ResponseEntity.ok((Object)this.middlewareUserService.findById(this.scaInfoHolder.getUserId()));
    }

    @PreAuthorize(value="tokenUsage('DIRECT_ACCESS')")
    public ResponseEntity<Void> updateUserScaData(List<ScaUserDataTO> data) {
        UserTO userTO = this.middlewareUserService.findById(this.scaInfoHolder.getUserId());
        UserTO user = this.middlewareUserService.updateScaData(userTO.getLogin(), data);
        URI uri = UriComponentsBuilder.fromUriString((String)("/users/" + user.getId())).build().toUri();
        return ResponseEntity.created((URI)uri).build();
    }

    @PutMapping(value={"/{userId}/sca-data"})
    @ApiOperation(value="Updates user SCA", notes="Updates user authentication methods.<lu><li>User is implied from the provided access token.</li><li>Actor token (delegation token like ais consent token) can not be used to execute this operation</li></ul>", authorizations={@Authorization(value="apiKey")})
    @ApiResponses(value={@ApiResponse(code=200, message="The user data record without the user pin."), @ApiResponse(code=401, message="Provided bearer token could not be verified."), @ApiResponse(code=403, message="Provided bearer token not qualified for this operation.")})
    @PreAuthorize(value="hasAnyRole('STAFF','SYSTEM')")
    public ResponseEntity<Void> updateScaDataByUserId(@PathVariable String userId, @RequestBody List<ScaUserDataTO> data) {
        UserTO userTO = this.middlewareUserService.findById(userId);
        UserTO user = this.middlewareUserService.updateScaData(userTO.getLogin(), data);
        URI uri = UriComponentsBuilder.fromUriString((String)("/users/" + user.getId())).build().toUri();
        return ResponseEntity.created((URI)uri).build();
    }

    @PreAuthorize(value="hasAnyRole('STAFF','SYSTEM')")
    public ResponseEntity<List<UserTO>> getAllUsers() {
        return ResponseEntity.ok((Object)this.middlewareUserService.listUsers(0, 1000));
    }

    public UserMgmtResource(MiddlewareOnlineBankingService onlineBankingService, MiddlewareUserManagementService middlewareUserService, ScaInfoHolder scaInfoHolder) {
        this.onlineBankingService = onlineBankingService;
        this.middlewareUserService = middlewareUserService;
        this.scaInfoHolder = scaInfoHolder;
    }
}

