/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.resource;

import de.adorsys.ledgers.middleware.api.domain.um.UploadedDataTO;
import de.adorsys.ledgers.middleware.api.service.AppManagementService;
import de.adorsys.ledgers.middleware.api.service.CurrencyService;
import de.adorsys.ledgers.middleware.api.service.MiddlewareAccountManagementService;
import de.adorsys.ledgers.middleware.rest.annotation.MiddlewareResetResource;
import de.adorsys.ledgers.middleware.rest.resource.DataMgmtStaffAPI;
import de.adorsys.ledgers.middleware.rest.security.ScaInfoHolder;
import java.util.Currency;
import java.util.Set;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@MiddlewareResetResource
@RequestMapping(value={"/staff-access/data"})
public class DataMgmtStaffResource
implements DataMgmtStaffAPI {
    private final ScaInfoHolder scaInfoHolder;
    private final MiddlewareAccountManagementService accountManagementService;
    private final AppManagementService appManagementService;
    private final CurrencyService currencyService;

    @PreAuthorize(value="hasAnyRole('STAFF','SYSTEM')")
    public ResponseEntity<Void> account(String iban) {
        this.accountManagementService.deleteTransactions(this.scaInfoHolder.getUserId(), this.scaInfoHolder.getScaInfo().getUserRole(), iban);
        return ResponseEntity.ok().build();
    }

    @PreAuthorize(value="hasAnyRole('STAFF','SYSTEM')")
    public ResponseEntity<Void> branch(String branchId) {
        this.appManagementService.removeBranch(this.scaInfoHolder.getUserId(), this.scaInfoHolder.getScaInfo().getUserRole(), branchId);
        return ResponseEntity.ok().build();
    }

    @PreAuthorize(value="hasAnyRole('STAFF','SYSTEM')")
    public ResponseEntity<Void> uploadData(UploadedDataTO data) {
        this.appManagementService.uploadData(data, this.scaInfoHolder.getScaInfo());
        return ResponseEntity.ok().build();
    }

    @PreAuthorize(value="hasAnyRole('STAFF','SYSTEM')")
    public ResponseEntity<Set<Currency>> currencies() {
        return ResponseEntity.ok((Object)this.currencyService.getSupportedCurrencies());
    }

    public DataMgmtStaffResource(ScaInfoHolder scaInfoHolder, MiddlewareAccountManagementService accountManagementService, AppManagementService appManagementService, CurrencyService currencyService) {
        this.scaInfoHolder = scaInfoHolder;
        this.accountManagementService = accountManagementService;
        this.appManagementService = appManagementService;
        this.currencyService = currencyService;
    }
}

