/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.resource;

import de.adorsys.ledgers.middleware.api.domain.account.AccountBalanceTO;
import de.adorsys.ledgers.middleware.api.domain.account.AccountDetailsTO;
import de.adorsys.ledgers.middleware.api.domain.account.FundsConfirmationRequestTO;
import de.adorsys.ledgers.middleware.api.domain.account.TransactionTO;
import de.adorsys.ledgers.middleware.api.domain.payment.AmountTO;
import de.adorsys.ledgers.middleware.api.exception.MiddlewareErrorCode;
import de.adorsys.ledgers.middleware.api.exception.MiddlewareModuleException;
import de.adorsys.ledgers.middleware.api.service.MiddlewareAccountManagementService;
import de.adorsys.ledgers.middleware.rest.annotation.MiddlewareUserResource;
import de.adorsys.ledgers.middleware.rest.resource.AccountRestAPI;
import de.adorsys.ledgers.middleware.rest.security.ScaInfoHolder;
import de.adorsys.ledgers.util.domain.CustomPageImpl;
import de.adorsys.ledgers.util.domain.CustomPageableImpl;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@MiddlewareUserResource
@RequestMapping(value={"/accounts"})
public class AccountResource
implements AccountRestAPI {
    private static final Logger log = LoggerFactory.getLogger(AccountResource.class);
    private final ScaInfoHolder scaInfoHolder;
    private final MiddlewareAccountManagementService middlewareAccountService;

    @PreAuthorize(value="hasAnyRole('CUSTOMER','SYSTEM')")
    public ResponseEntity<List<AccountDetailsTO>> getListOfAccounts() {
        return ResponseEntity.ok((Object)this.middlewareAccountService.listDepositAccounts(this.scaInfoHolder.getUserId()));
    }

    @PreAuthorize(value="hasRole('CUSTOMER') and tokenUsage('DIRECT_ACCESS')")
    public ResponseEntity<Void> createDepositAccount(AccountDetailsTO accountDetailsTO) {
        String iban = accountDetailsTO.getIban();
        String accountNumberPrefix = StringUtils.substring((String)iban, (int)0, (int)(iban.length() - 2));
        String accountNumberSuffix = StringUtils.substringAfter((String)iban, (String)accountNumberPrefix);
        this.middlewareAccountService.createDepositAccount(this.scaInfoHolder.getScaInfo(), accountNumberPrefix, accountNumberSuffix, accountDetailsTO);
        return ResponseEntity.ok().build();
    }

    @PreAuthorize(value="accountInfoById(#accountId)")
    public ResponseEntity<AccountDetailsTO> getAccountDetailsById(String accountId) {
        return ResponseEntity.ok((Object)this.middlewareAccountService.getDepositAccountById(accountId, LocalDateTime.now(), true));
    }

    @PreAuthorize(value="accountInfoById(#accountId)")
    public ResponseEntity<List<AccountBalanceTO>> getBalances(String accountId) {
        AccountDetailsTO accountDetails = this.middlewareAccountService.getDepositAccountById(accountId, LocalDateTime.now(), true);
        return ResponseEntity.ok((Object)accountDetails.getBalances());
    }

    @PreAuthorize(value="accountInfoById(#accountId)")
    public ResponseEntity<List<TransactionTO>> getTransactionByDates(String accountId, LocalDate dateFrom, LocalDate dateTo) {
        this.dateChecker(dateFrom, dateTo);
        List transactions = this.middlewareAccountService.getTransactionsByDates(accountId, this.validDate(dateFrom), this.validDate(dateTo));
        return ResponseEntity.ok((Object)transactions);
    }

    @PreAuthorize(value="accountInfoById(#accountId)")
    public ResponseEntity<CustomPageImpl<TransactionTO>> getTransactionByDatesPaged(String accountId, LocalDate dateFrom, LocalDate dateTo, int page, int size) {
        this.dateChecker(dateFrom, dateTo);
        CustomPageableImpl pageable = new CustomPageableImpl(page, size);
        CustomPageImpl customPage = this.middlewareAccountService.getTransactionsByDatesPaged(accountId, dateFrom, dateTo, pageable);
        return ResponseEntity.ok((Object)customPage);
    }

    @PreAuthorize(value="accountInfoById(#accountId)")
    public ResponseEntity<TransactionTO> getTransactionById(String accountId, String transactionId) {
        return ResponseEntity.ok((Object)this.middlewareAccountService.getTransactionById(accountId, transactionId));
    }

    @PreAuthorize(value="accountInfoByIban(#iban)")
    public ResponseEntity<AccountDetailsTO> getAccountDetailsByIban(String iban) {
        return ResponseEntity.ok((Object)this.middlewareAccountService.getDepositAccountByIban(iban, LocalDateTime.now(), true));
    }

    @PreAuthorize(value="accountInfoByIban(#request.psuAccount.iban)")
    public ResponseEntity<Boolean> fundsConfirmation(FundsConfirmationRequestTO request) {
        if (request.getInstructedAmount().getAmount().compareTo(BigDecimal.ZERO) != 1) {
            throw MiddlewareModuleException.builder().errorCode(MiddlewareErrorCode.REQUEST_VALIDATION_FAILURE).devMsg("Requested amount less or equal zero").build();
        }
        boolean fundsAvailable = this.middlewareAccountService.confirmFundsAvailability(request);
        return ResponseEntity.ok((Object)fundsAvailable);
    }

    @PreAuthorize(value="hasAnyRole('STAFF','SYSTEM')")
    public ResponseEntity<Void> depositCash(String accountId, AmountTO amount) {
        this.middlewareAccountService.depositCash(this.scaInfoHolder.getScaInfo(), accountId, amount);
        return ResponseEntity.accepted().build();
    }

    private void dateChecker(LocalDate dateFrom, LocalDate dateTo) {
        if (!this.validDate(dateFrom).isEqual(this.validDate(dateTo)) && this.validDate(dateFrom).isAfter(this.validDate(dateTo))) {
            throw MiddlewareModuleException.builder().errorCode(MiddlewareErrorCode.REQUEST_VALIDATION_FAILURE).devMsg("Illegal request dates sequence, possibly swapped 'date from' with 'date to'").build();
        }
    }

    private LocalDate validDate(LocalDate date) {
        return Optional.ofNullable(date).orElseGet(LocalDate::now);
    }

    public AccountResource(ScaInfoHolder scaInfoHolder, MiddlewareAccountManagementService middlewareAccountService) {
        this.scaInfoHolder = scaInfoHolder;
        this.middlewareAccountService = middlewareAccountService;
    }
}

