/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.resource;

import de.adorsys.ledgers.middleware.api.domain.account.AccountDetailsTO;
import de.adorsys.ledgers.middleware.api.domain.account.AccountReportTO;
import de.adorsys.ledgers.middleware.api.domain.payment.AmountTO;
import de.adorsys.ledgers.middleware.api.service.MiddlewareAccountManagementService;
import de.adorsys.ledgers.middleware.rest.annotation.MiddlewareUserResource;
import de.adorsys.ledgers.middleware.rest.resource.AccountMgmStaffResourceAPI;
import de.adorsys.ledgers.middleware.rest.security.ScaInfoHolder;
import de.adorsys.ledgers.util.domain.CustomPageImpl;
import de.adorsys.ledgers.util.domain.CustomPageableImpl;
import java.time.LocalDateTime;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@MiddlewareUserResource
@RequestMapping(value={"/staff-access/accounts"})
public class AccountMgmStaffResource
implements AccountMgmStaffResourceAPI {
    private static final Logger log = LoggerFactory.getLogger(AccountMgmStaffResource.class);
    private final MiddlewareAccountManagementService middlewareAccountService;
    private final ScaInfoHolder scaInfoHolder;

    public ResponseEntity<List<AccountDetailsTO>> getAccountsByIbanAndCurrency(String iban, String currency) {
        return ResponseEntity.ok((Object)this.middlewareAccountService.getAccountsByIbanAndCurrency(iban, currency));
    }

    @PreAuthorize(value="hasRole('STAFF')")
    public ResponseEntity<Void> createDepositAccountForUser(String userId, AccountDetailsTO accountDetailsTO) {
        this.middlewareAccountService.createDepositAccount(userId, this.scaInfoHolder.getScaInfo(), accountDetailsTO);
        return ResponseEntity.ok().build();
    }

    @PreAuthorize(value="hasRole('STAFF')")
    public ResponseEntity<List<AccountDetailsTO>> getListOfAccounts() {
        return ResponseEntity.ok((Object)this.middlewareAccountService.listDepositAccountsByBranch(this.scaInfoHolder.getUserId()));
    }

    @PreAuthorize(value="hasRole('STAFF')")
    public ResponseEntity<CustomPageImpl<AccountDetailsTO>> getListOfAccountsPaged(String queryParam, int page, int size) {
        CustomPageableImpl pageable = new CustomPageableImpl(page, size);
        CustomPageImpl details = this.middlewareAccountService.listDepositAccountsByBranchPaged(this.scaInfoHolder.getUserId(), queryParam, pageable);
        return ResponseEntity.ok((Object)details);
    }

    @PreAuthorize(value="accountInfoById(#accountId)")
    public ResponseEntity<AccountDetailsTO> getAccountDetailsById(String accountId) {
        return ResponseEntity.ok((Object)this.middlewareAccountService.getDepositAccountById(accountId, LocalDateTime.now(), true));
    }

    @PreAuthorize(value="hasAnyRole('STAFF','SYSTEM')&&accountInfoById(#accountId)")
    public ResponseEntity<Void> depositCash(String accountId, AmountTO amount) {
        this.middlewareAccountService.depositCash(this.scaInfoHolder.getScaInfo(), accountId, amount);
        return ResponseEntity.accepted().build();
    }

    @PreAuthorize(value="accountInfoById(#accountId)")
    public ResponseEntity<AccountReportTO> getExtendedAccountDetailsById(String accountId) {
        long start = System.nanoTime();
        AccountReportTO accountReport = this.middlewareAccountService.getAccountReport(accountId);
        log.info("Loaded report in {} seconds", (Object)TimeUnit.SECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS));
        return ResponseEntity.ok((Object)accountReport);
    }

    public AccountMgmStaffResource(MiddlewareAccountManagementService middlewareAccountService, ScaInfoHolder scaInfoHolder) {
        this.middlewareAccountService = middlewareAccountService;
        this.scaInfoHolder = scaInfoHolder;
    }
}

