/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.security;

import de.adorsys.ledgers.middleware.api.domain.um.AccessTokenTO;
import de.adorsys.ledgers.middleware.api.domain.um.AccountAccessTO;
import de.adorsys.ledgers.middleware.api.domain.um.AisAccountAccessInfoTO;
import de.adorsys.ledgers.middleware.api.domain.um.AisConsentTO;
import de.adorsys.ledgers.middleware.api.domain.um.TokenUsageTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserRoleTO;
import de.adorsys.ledgers.middleware.api.service.MiddlewareAccountManagementService;
import de.adorsys.ledgers.middleware.api.service.MiddlewarePaymentService;
import de.adorsys.ledgers.middleware.rest.security.MiddlewareAuthentication;
import de.adorsys.ledgers.middleware.rest.security.SecurityExpressionAdapter;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.core.Authentication;

public class AccountAccessMethodSecurityExpressionRoot
extends SecurityExpressionAdapter {
    public AccountAccessMethodSecurityExpressionRoot(Authentication authentication, MiddlewareAccountManagementService accountService, MiddlewarePaymentService paymentService) {
        super(authentication, accountService, paymentService);
    }

    public boolean accountInfoById(String id) {
        String iban = this.accountService.iban(id);
        return this.checkAccountInfoAccess(iban);
    }

    public boolean accountInfoByIban(String iban) {
        return this.checkAccountInfoAccess(iban);
    }

    public boolean accountInfoFor(AisConsentTO consent) {
        AisAccountAccessInfoTO access = consent.getAccess();
        return access != null && this.accountInfoByIbanList(access.getAccounts()) && this.accountInfoByIbanList(access.getTransactions()) && this.accountInfoByIbanList(access.getBalances());
    }

    public boolean tokenUsage(String usageType) {
        return this.checkTokenUsage(usageType);
    }

    public boolean loginToken(String scaId, String authorizationId) {
        AccessTokenTO token = this.getAccessTokenTO();
        return this.checkTokenUsage(TokenUsageTO.LOGIN.name()) && scaId.equals(token.getScaId()) && authorizationId.equals(token.getAuthorisationId());
    }

    public boolean paymentInitById(String paymentId) {
        String iban = this.paymentService.iban(paymentId);
        return this.checkPaymentInitAccess(iban);
    }

    public boolean paymentInfoById(String paymentId) {
        String iban = this.paymentService.iban(paymentId);
        return this.checkAccountInfoAccess(iban) || this.checkPaymentInitAccess(iban);
    }

    private boolean checkPaymentInitAccess(String iban) {
        AccessTokenTO token = this.getAccessTokenTO();
        if (EnumSet.of(UserRoleTO.CUSTOMER, UserRoleTO.STAFF).contains(token.getRole())) {
            return this.getAccountAccesses(token.getSub()).stream().anyMatch(a -> a.hasPaymentAccess(iban));
        }
        return UserRoleTO.SYSTEM == token.getRole();
    }

    private List<AccountAccessTO> getAccountAccesses(String userId) {
        return this.accountService.getAccountAccesses(userId);
    }

    private boolean checkAccountInfoAccess(String iban) {
        if (StringUtils.isBlank((CharSequence)iban)) {
            return false;
        }
        AccessTokenTO token = this.getAccessTokenTO();
        if (UserRoleTO.SYSTEM == token.getRole()) {
            return true;
        }
        if (EnumSet.of(UserRoleTO.CUSTOMER, UserRoleTO.STAFF).contains(token.getRole())) {
            return this.getAccountAccesses(token.getSub()).stream().anyMatch(a -> a.hasIban(iban)) || this.checkConsentAccess(token, iban);
        }
        return false;
    }

    private boolean checkConsentAccess(AccessTokenTO token, String iban) {
        return token.hasValidConsent() && this.checkConsentAccess(iban, token.getConsent().getAccess());
    }

    private boolean checkConsentAccess(String iban, AisAccountAccessInfoTO access) {
        return access != null && access.hasIbanInAccess(iban);
    }

    private boolean accountInfoByIbanList(List<String> ibanList) {
        if (CollectionUtils.isEmpty(ibanList)) {
            return true;
        }
        for (String iban : ibanList) {
            if (this.checkAccountInfoAccess(iban)) continue;
            return false;
        }
        return true;
    }

    private boolean checkTokenUsage(String usageType) {
        AccessTokenTO token = this.getAccessTokenTO();
        return token.getTokenUsage() != null && token.getTokenUsage().name().equals(usageType);
    }

    private AccessTokenTO getAccessTokenTO() {
        MiddlewareAuthentication authentication = (MiddlewareAuthentication)this.getAuthentication();
        return authentication.getBearerToken().getAccessTokenObject();
    }
}

