/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.security;

import de.adorsys.ledgers.middleware.api.domain.um.AisAccountAccessInfoTO;
import de.adorsys.ledgers.middleware.api.domain.um.AisConsentTO;
import de.adorsys.ledgers.middleware.api.service.MiddlewareAccountManagementService;
import de.adorsys.ledgers.middleware.api.service.MiddlewarePaymentService;
import de.adorsys.ledgers.middleware.rest.security.MiddlewareAuthentication;
import java.util.List;
import java.util.Map;
import org.springframework.security.access.expression.SecurityExpressionRoot;
import org.springframework.security.access.expression.method.MethodSecurityExpressionOperations;
import org.springframework.security.core.Authentication;

public class AccountAccessMethodSecurityExpressionRoot
extends SecurityExpressionRoot
implements MethodSecurityExpressionOperations {
    private final MiddlewareAccountManagementService middlewareAccountService;
    private final MiddlewarePaymentService middlewareService;
    private Object filterObject;
    private Object returnObject;
    private Object target;

    public AccountAccessMethodSecurityExpressionRoot(Authentication authentication, MiddlewareAccountManagementService middlewareAccountService, MiddlewarePaymentService middlewareService) {
        super(authentication);
        this.middlewareAccountService = middlewareAccountService;
        this.middlewareService = middlewareService;
    }

    public boolean paymentInitByIban(String iban) {
        MiddlewareAuthentication m = (MiddlewareAuthentication)this.getAuthentication();
        return m.checkPaymentInitAccess(iban);
    }

    public boolean paymentInit(Object payment) {
        Map map = (Map)payment;
        if (map.size() == 1) {
            map = (Map)map.values().iterator().next();
        }
        Map debtorAccount = (Map)map.get("debtorAccount");
        String iban = (String)debtorAccount.get("iban");
        MiddlewareAuthentication m = (MiddlewareAuthentication)this.getAuthentication();
        return m.checkPaymentInitAccess(iban);
    }

    public boolean paymentInitById(String paymentId) {
        String iban = this.middlewareService.iban(paymentId);
        return this.paymentInitByIban(iban);
    }

    public boolean paymentInfoById(String paymentId) {
        String iban = this.middlewareService.iban(paymentId);
        MiddlewareAuthentication m = (MiddlewareAuthentication)this.getAuthentication();
        return m.checkAccountInfoAccess(iban) || this.paymentInitByIban(iban);
    }

    public boolean accountInfoByIban(String iban) {
        MiddlewareAuthentication m = (MiddlewareAuthentication)this.getAuthentication();
        return m.checkAccountInfoAccess(iban);
    }

    public boolean accountInfoById(String id) {
        String iban = this.middlewareAccountService.iban(id);
        return iban != null && this.accountInfoByIban(iban);
    }

    public boolean accountInfoFor(AisConsentTO consent) {
        AisAccountAccessInfoTO access = consent.getAccess();
        return access != null && this.accountInfoByIbanList(access.getAccounts()) && this.accountInfoByIbanList(access.getTransactions()) && this.accountInfoByIbanList(access.getBalances());
    }

    private boolean accountInfoByIbanList(List<String> ibanList) {
        if (ibanList == null || ibanList.isEmpty()) {
            return true;
        }
        for (String iban : ibanList) {
            if (this.accountInfoByIban(iban)) continue;
            return false;
        }
        return true;
    }

    public boolean tokenUsage(String usageType) {
        MiddlewareAuthentication m = (MiddlewareAuthentication)this.getAuthentication();
        return m.checkTokenUsage(usageType);
    }

    public boolean loginToken(String scaId, String authorizationId) {
        MiddlewareAuthentication m = (MiddlewareAuthentication)this.getAuthentication();
        return m.checkLoginToken(scaId, authorizationId);
    }

    public void setFilterObject(Object filterObject) {
        this.filterObject = filterObject;
    }

    public Object getFilterObject() {
        return this.filterObject;
    }

    public void setReturnObject(Object returnObject) {
        this.returnObject = returnObject;
    }

    public Object getReturnObject() {
        return this.returnObject;
    }

    void setThis(Object target) {
        this.target = target;
    }

    public Object getThis() {
        return this.target;
    }
}

