/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.resource;

import de.adorsys.ledgers.middleware.api.domain.sca.SCALoginResponseTO;
import de.adorsys.ledgers.middleware.api.domain.um.AccessTokenTO;
import de.adorsys.ledgers.middleware.api.domain.um.ScaUserDataTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserCredentialsTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserRoleTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.ledgers.middleware.api.exception.InsufficientPermissionMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.UserAlreadyExistsMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.UserNotFoundMiddlewareException;
import de.adorsys.ledgers.middleware.api.service.MiddlewareOnlineBankingService;
import de.adorsys.ledgers.middleware.api.service.MiddlewareUserManagementService;
import de.adorsys.ledgers.middleware.rest.annotation.MiddlewareUserResource;
import de.adorsys.ledgers.middleware.rest.exception.ConflictRestException;
import de.adorsys.ledgers.middleware.rest.exception.ForbiddenRestException;
import de.adorsys.ledgers.middleware.rest.exception.NotFoundRestException;
import de.adorsys.ledgers.middleware.rest.resource.UserMgmtStaffResourceAPI;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@MiddlewareUserResource
@RequestMapping(value={"/staff-access/users"})
public class UserMgmtStaffResource
implements UserMgmtStaffResourceAPI {
    private final MiddlewareOnlineBankingService onlineBankingService;
    private final MiddlewareUserManagementService middlewareUserService;
    private final AccessTokenTO accessToken;

    public UserMgmtStaffResource(MiddlewareOnlineBankingService onlineBankingService, MiddlewareUserManagementService middlewareUserService, AccessTokenTO accessToken) {
        this.onlineBankingService = onlineBankingService;
        this.middlewareUserService = middlewareUserService;
        this.accessToken = accessToken;
    }

    public ResponseEntity<UserTO> register(String branch, UserTO branchStaff) throws ConflictRestException {
        try {
            if (this.middlewareUserService.countUsersByBranch(branch) > 0) {
                throw new ForbiddenRestException("User cannot register for this branch. The branch is occupied by other user");
            }
            branchStaff.setBranch(branch);
            branchStaff.setUserRoles(Collections.singletonList(UserRoleTO.STAFF));
            UserTO user = this.middlewareUserService.create(branchStaff);
            user.setPin(null);
            return ResponseEntity.ok((Object)user);
        }
        catch (UserAlreadyExistsMiddlewareException e) {
            throw new ConflictRestException(e.getMessage()).withDevMessage(e.getMessage());
        }
    }

    public ResponseEntity<SCALoginResponseTO> login(UserCredentialsTO userCredentials) throws NotFoundRestException, ForbiddenRestException {
        try {
            return ResponseEntity.ok((Object)this.onlineBankingService.authorise(userCredentials.getLogin(), userCredentials.getPin(), UserRoleTO.STAFF));
        }
        catch (UserNotFoundMiddlewareException e) {
            throw new NotFoundRestException(e.getMessage()).withDevMessage(e.getMessage());
        }
        catch (InsufficientPermissionMiddlewareException e) {
            throw new ForbiddenRestException(e.getMessage()).withDevMessage(e.getMessage());
        }
    }

    @PreAuthorize(value="hasRole('STAFF')")
    public ResponseEntity<UserTO> createUser(UserTO user) throws NotFoundRestException, ConflictRestException {
        try {
            UserTO branchStaff = this.middlewareUserService.findById(this.accessToken.getSub());
            user.setBranch(branchStaff.getBranch());
            user.getUserRoles().remove(UserRoleTO.SYSTEM);
            user.getUserRoles().remove(UserRoleTO.TECHNICAL);
            UserTO newUser = this.middlewareUserService.create(user);
            newUser.setPin(null);
            return ResponseEntity.ok((Object)newUser);
        }
        catch (UserNotFoundMiddlewareException e) {
            throw new NotFoundRestException(e.getMessage());
        }
        catch (UserAlreadyExistsMiddlewareException e) {
            throw new ConflictRestException(e.getMessage()).withDevMessage(e.getMessage());
        }
    }

    @PreAuthorize(value="hasRole('STAFF')")
    public ResponseEntity<List<UserTO>> getBranchUsersByRoles(List<UserRoleTO> roles) throws NotFoundRestException {
        try {
            UserTO branchStaff = this.middlewareUserService.findById(this.accessToken.getSub());
            List users = this.middlewareUserService.getUsersByBranchAndRoles(branchStaff.getBranch(), roles);
            return ResponseEntity.ok((Object)users);
        }
        catch (UserNotFoundMiddlewareException e) {
            throw new NotFoundRestException(e.getMessage());
        }
    }

    @PreAuthorize(value="hasRole('STAFF')")
    public ResponseEntity<UserTO> getBranchUserById(String userId) throws NotFoundRestException {
        try {
            UserTO user = this.findUserForBranch(userId);
            return ResponseEntity.ok((Object)user);
        }
        catch (UserNotFoundMiddlewareException e) {
            throw new NotFoundRestException(e.getMessage());
        }
    }

    @PreAuthorize(value="hasRole('STAFF')")
    public ResponseEntity<Void> updateUserScaData(String userId, List<ScaUserDataTO> data) {
        try {
            UserTO user = this.findUserForBranch(userId);
            UserTO userWithUpdatedSca = this.middlewareUserService.updateScaData(user.getLogin(), data);
            URI uri = UriComponentsBuilder.fromUriString((String)("/staff-access/users/" + userWithUpdatedSca.getId())).build().toUri();
            return ResponseEntity.created((URI)uri).build();
        }
        catch (UserNotFoundMiddlewareException e) {
            throw new NotFoundRestException(e.getMessage());
        }
    }

    private UserTO findUserForBranch(String userId) throws UserNotFoundMiddlewareException {
        UserTO branchStaff = this.middlewareUserService.findById(this.accessToken.getSub());
        UserTO user = this.middlewareUserService.findById(userId);
        if (!branchStaff.getBranch().equals(user.getBranch())) {
            throw new ForbiddenRestException("User is not your branch");
        }
        return user;
    }
}

