/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.resource;

import de.adorsys.ledgers.middleware.api.domain.sca.OpTypeTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCALoginResponseTO;
import de.adorsys.ledgers.middleware.api.domain.um.AccessTokenTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.api.domain.um.ScaUserDataTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserRoleTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.ledgers.middleware.api.exception.InsufficientPermissionMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.SCAMethodNotSupportedMiddleException;
import de.adorsys.ledgers.middleware.api.exception.SCAOperationExpiredMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.SCAOperationNotFoundMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.SCAOperationUsedOrStolenMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.SCAOperationValidationMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.UserAlreadyExistsMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.UserNotFoundMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.UserScaDataNotFoundMiddlewareException;
import de.adorsys.ledgers.middleware.api.service.MiddlewareOnlineBankingService;
import de.adorsys.ledgers.middleware.api.service.MiddlewareUserManagementService;
import de.adorsys.ledgers.middleware.rest.annotation.MiddlewareUserResource;
import de.adorsys.ledgers.middleware.rest.exception.ConflictRestException;
import de.adorsys.ledgers.middleware.rest.exception.ExpectationFailedRestException;
import de.adorsys.ledgers.middleware.rest.exception.ForbiddenRestException;
import de.adorsys.ledgers.middleware.rest.exception.GoneRestException;
import de.adorsys.ledgers.middleware.rest.exception.NotAcceptableRestException;
import de.adorsys.ledgers.middleware.rest.exception.NotFoundRestException;
import de.adorsys.ledgers.middleware.rest.exception.ValidationRestException;
import de.adorsys.ledgers.middleware.rest.resource.UserMgmtRestAPI;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.net.URI;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/users"})
@MiddlewareUserResource
public class UserMgmtResource
implements UserMgmtRestAPI {
    private static final Logger logger = LoggerFactory.getLogger(UserMgmtResource.class);
    private final MiddlewareOnlineBankingService onlineBankingService;
    private final MiddlewareUserManagementService middlewareUserService;
    private final AccessTokenTO accessToken;

    public UserMgmtResource(MiddlewareOnlineBankingService onlineBankingService, MiddlewareUserManagementService middlewareUserService, AccessTokenTO accessToken) {
        this.onlineBankingService = onlineBankingService;
        this.middlewareUserService = middlewareUserService;
        this.accessToken = accessToken;
    }

    public ResponseEntity<UserTO> register(String login, String email, String pin, UserRoleTO role) {
        try {
            UserTO user = this.onlineBankingService.register(login, email, pin, role);
            user.setPin(null);
            return ResponseEntity.ok((Object)user);
        }
        catch (UserAlreadyExistsMiddlewareException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ConflictRestException(e.getMessage()).withDevMessage(e.getMessage());
        }
    }

    public ResponseEntity<SCALoginResponseTO> authorise(String login, String pin, UserRoleTO role) {
        try {
            return ResponseEntity.ok((Object)this.onlineBankingService.authorise(login, pin, role));
        }
        catch (UserNotFoundMiddlewareException e) {
            logger.error(e.getMessage());
            throw new NotFoundRestException(e.getMessage()).withDevMessage(e.getMessage());
        }
        catch (InsufficientPermissionMiddlewareException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ForbiddenRestException(e.getMessage()).withDevMessage(e.getMessage());
        }
    }

    public ResponseEntity<SCALoginResponseTO> authoriseForConsent(String login, String pin, String consentId, String authorisationId, OpTypeTO opType) {
        try {
            return ResponseEntity.ok((Object)this.onlineBankingService.authoriseForConsent(login, pin, consentId, authorisationId, opType));
        }
        catch (UserNotFoundMiddlewareException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new NotFoundRestException(e.getMessage()).withDevMessage(e.getMessage());
        }
        catch (InsufficientPermissionMiddlewareException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ForbiddenRestException(e.getMessage()).withDevMessage(e.getMessage());
        }
    }

    @PreAuthorize(value="loginToken(#scaId,#authorisationId)")
    public ResponseEntity<SCALoginResponseTO> selectMethod(String scaId, String authorisationId, String scaMethodId) throws NotFoundRestException, ForbiddenRestException, NotAcceptableRestException, ValidationRestException {
        try {
            return ResponseEntity.ok((Object)this.onlineBankingService.generateLoginAuthCode(scaMethodId, authorisationId, null, 1800));
        }
        catch (SCAOperationNotFoundMiddlewareException | UserScaDataNotFoundMiddlewareException e) {
            logger.error(e.getMessage(), e);
            throw new NotFoundRestException(e.getMessage());
        }
        catch (InsufficientPermissionMiddlewareException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ForbiddenRestException(e.getMessage());
        }
        catch (SCAMethodNotSupportedMiddleException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new NotAcceptableRestException(e.getMessage());
        }
        catch (SCAOperationValidationMiddlewareException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ValidationRestException(e.getMessage());
        }
    }

    @PreAuthorize(value="loginToken(#scaId,#authorisationId)")
    public ResponseEntity<SCALoginResponseTO> authorizeLogin(String scaId, String authorisationId, String authCode) throws GoneRestException, NotFoundRestException, ExpectationFailedRestException, NotAcceptableRestException, ForbiddenRestException {
        try {
            return ResponseEntity.ok((Object)this.onlineBankingService.authenticateForLogin(authorisationId, authCode));
        }
        catch (SCAOperationNotFoundMiddlewareException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new NotFoundRestException(e.getMessage());
        }
        catch (SCAOperationValidationMiddlewareException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ExpectationFailedRestException(e.getMessage());
        }
        catch (SCAOperationExpiredMiddlewareException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new GoneRestException(e.getMessage());
        }
        catch (SCAOperationUsedOrStolenMiddlewareException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new NotAcceptableRestException(e.getMessage());
        }
        catch (InsufficientPermissionMiddlewareException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ForbiddenRestException(e.getMessage());
        }
    }

    public ResponseEntity<BearerTokenTO> validate(String token) {
        try {
            BearerTokenTO tokenTO = this.onlineBankingService.validate(token);
            if (tokenTO != null) {
                return ResponseEntity.ok((Object)tokenTO);
            }
            logger.error("Token is null !!!");
            throw new ForbiddenRestException("Token invalid");
        }
        catch (InsufficientPermissionMiddlewareException | UserNotFoundMiddlewareException e) {
            logger.error(e.getMessage(), e);
            throw new ForbiddenRestException(e.getMessage()).withDevMessage(e.getMessage());
        }
    }

    @PreAuthorize(value="hasAnyRole('STAFF','SYSTEM')")
    public ResponseEntity<UserTO> getUserById(String userId) {
        try {
            return ResponseEntity.ok((Object)this.middlewareUserService.findById(userId));
        }
        catch (UserNotFoundMiddlewareException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new NotFoundRestException(e.getMessage());
        }
    }

    @PreAuthorize(value="tokenUsage('DIRECT_ACCESS')")
    public ResponseEntity<UserTO> getUser() {
        try {
            return ResponseEntity.ok((Object)this.middlewareUserService.findById(this.accessToken.getSub()));
        }
        catch (UserNotFoundMiddlewareException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new NotFoundRestException(e.getMessage());
        }
    }

    @PreAuthorize(value="tokenUsage('DIRECT_ACCESS')")
    public ResponseEntity<Void> updateUserScaData(List<ScaUserDataTO> data) {
        try {
            UserTO userTO = this.middlewareUserService.findById(this.accessToken.getSub());
            UserTO user = this.middlewareUserService.updateScaData(userTO.getLogin(), data);
            URI uri = UriComponentsBuilder.fromUriString((String)("/users/" + user.getId())).build().toUri();
            return ResponseEntity.created((URI)uri).build();
        }
        catch (UserNotFoundMiddlewareException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new NotFoundRestException(e.getMessage());
        }
    }

    @PutMapping(value={"/{userId}/sca-data"})
    @ApiOperation(value="Updates user SCA", notes="Updates user authentication methods.<lu><li>User is implied from the provided access token.</li><li>Actor token (delegation token like ais consent token) can not be used to execute this operation</li></ul>", authorizations={@Authorization(value="apiKey")})
    @ApiResponses(value={@ApiResponse(code=200, response=Void.class, message="The user data record without the user pin."), @ApiResponse(code=401, message="Provided bearer token could not be verified."), @ApiResponse(code=403, message="Provided bearer token not qualified for this operation.")})
    @PreAuthorize(value="hasAnyRole('STAFF','SYSTEM')")
    public ResponseEntity<Void> updateScaDataByUserId(@PathVariable String userId, @RequestBody List<ScaUserDataTO> data) {
        try {
            UserTO userTO = this.middlewareUserService.findById(userId);
            UserTO user = this.middlewareUserService.updateScaData(userTO.getLogin(), data);
            URI uri = UriComponentsBuilder.fromUriString((String)("/users/" + user.getId())).build().toUri();
            return ResponseEntity.created((URI)uri).build();
        }
        catch (UserNotFoundMiddlewareException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new NotFoundRestException(e.getMessage());
        }
    }

    @PreAuthorize(value="hasAnyRole('STAFF','SYSTEM')")
    public ResponseEntity<List<UserTO>> getAllUsers() {
        return ResponseEntity.ok((Object)this.middlewareUserService.listUsers(0, 150));
    }
}

