/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.resource;

import de.adorsys.ledgers.middleware.api.domain.account.AccountDetailsTO;
import de.adorsys.ledgers.middleware.api.domain.payment.AmountTO;
import de.adorsys.ledgers.middleware.api.exception.AccountNotFoundMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.InsufficientPermissionMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.UserNotFoundMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.UserNotInBranchMiddlewareException;
import de.adorsys.ledgers.middleware.api.service.MiddlewareAccountManagementService;
import de.adorsys.ledgers.middleware.rest.annotation.MiddlewareUserResource;
import de.adorsys.ledgers.middleware.rest.exception.NotFoundRestException;
import de.adorsys.ledgers.middleware.rest.resource.AccountMgmStaffResourceAPI;
import java.time.LocalDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@MiddlewareUserResource
@RequestMapping(value={"/staff-access/accounts"})
public class AccountMgmStaffResource
implements AccountMgmStaffResourceAPI {
    private static final Logger logger = LoggerFactory.getLogger(AccountMgmStaffResource.class);
    private final MiddlewareAccountManagementService middlewareAccountService;

    public AccountMgmStaffResource(MiddlewareAccountManagementService middlewareAccountService) {
        this.middlewareAccountService = middlewareAccountService;
    }

    @PreAuthorize(value="hasRole('STAFF')")
    public ResponseEntity<Void> createDepositAccountForUser(String userID, AccountDetailsTO accountDetailsTO) {
        try {
            this.middlewareAccountService.createDepositAccount(userID, accountDetailsTO);
            return ResponseEntity.ok().build();
        }
        catch (UserNotFoundMiddlewareException e) {
            return ResponseEntity.notFound().build();
        }
        catch (UserNotInBranchMiddlewareException e) {
            return ResponseEntity.status((int)403).build();
        }
        catch (Throwable e) {
            return ResponseEntity.status((int)500).build();
        }
    }

    @PreAuthorize(value="hasRole('STAFF')")
    public ResponseEntity<List<AccountDetailsTO>> getListOfAccounts() {
        return ResponseEntity.ok((Object)this.middlewareAccountService.listDepositAccountsByBranch());
    }

    @PreAuthorize(value="accountInfoById(#accountId)")
    public ResponseEntity<AccountDetailsTO> getAccountDetailsById(String accountId) {
        try {
            return ResponseEntity.ok((Object)this.middlewareAccountService.getDepositAccountById(accountId, LocalDateTime.now(), true));
        }
        catch (AccountNotFoundMiddlewareException | InsufficientPermissionMiddlewareException e) {
            logger.error(e.getMessage(), e);
            throw new NotFoundRestException(e.getMessage()).withDevMessage(e.getMessage());
        }
    }

    @PreAuthorize(value="hasRole('STAFF')")
    public ResponseEntity<Void> depositCash(String accountId, AmountTO amount) {
        try {
            this.middlewareAccountService.depositCash(accountId, amount);
            return ResponseEntity.accepted().build();
        }
        catch (AccountNotFoundMiddlewareException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new NotFoundRestException(e.getMessage()).withDevMessage(e.getMessage());
        }
    }
}

