/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.security;

import de.adorsys.ledgers.middleware.api.domain.um.AccessTokenTO;
import de.adorsys.ledgers.middleware.api.domain.um.AccessTypeTO;
import de.adorsys.ledgers.middleware.api.domain.um.AccountAccessTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.api.domain.um.TokenUsageTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserRoleTO;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;

public class MiddlewareAuthentication
extends UsernamePasswordAuthenticationToken {
    private static final long serialVersionUID = -778888356552035882L;

    public MiddlewareAuthentication(Object principal, Object credentials) {
        super(principal, credentials);
    }

    public MiddlewareAuthentication(Object principal, BearerTokenTO credentials, Collection<? extends GrantedAuthority> authorities) {
        super(principal, (Object)credentials, authorities);
    }

    public BearerTokenTO getBearerToken() {
        return (BearerTokenTO)this.getCredentials();
    }

    public boolean checkAccountInfoAccess(String iban) {
        BearerTokenTO bearerToken = this.getBearerToken();
        if (bearerToken == null) {
            return false;
        }
        AccessTokenTO token = bearerToken.getAccessTokenObject();
        if (UserRoleTO.STAFF == token.getRole() || UserRoleTO.SYSTEM == token.getRole()) {
            return true;
        }
        if (UserRoleTO.CUSTOMER == token.getRole()) {
            return token.getAccountAccesses() != null && token.getAccountAccesses().stream().filter(a -> StringUtils.equalsIgnoreCase((CharSequence)iban, (CharSequence)a.getIban())).findAny().isPresent();
        }
        return false;
    }

    public boolean checkPaymentInitAccess(String iban) {
        AccessTokenTO token = this.getBearerToken().getAccessTokenObject();
        if (UserRoleTO.CUSTOMER == token.getRole()) {
            return token.getAccountAccesses() != null && token.getAccountAccesses().stream().filter(a -> MiddlewareAuthentication.paymentAccess(a, iban)).findAny().isPresent();
        }
        return false;
    }

    private static boolean paymentAccess(AccountAccessTO a, String iban) {
        return StringUtils.equalsIgnoreCase((CharSequence)iban, (CharSequence)a.getIban()) && (AccessTypeTO.OWNER.equals((Object)a.getAccessType()) || AccessTypeTO.DISPOSE.equals((Object)a.getAccessType()));
    }

    public boolean checkTokenUsage(String usageType) {
        return this.getBearerToken().getAccessTokenObject().getTokenUsage() != null && this.getBearerToken().getAccessTokenObject().getTokenUsage().name().equals(usageType);
    }

    public boolean checkLoginToken(String scaId, String authorizationId) {
        return this.checkTokenUsage(TokenUsageTO.LOGIN.name()) && scaId.equals(this.getBearerToken().getAccessTokenObject().getScaId()) && authorizationId.equals(this.getBearerToken().getAccessTokenObject().getAuthorisationId());
    }
}

