/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.resource;

import de.adorsys.ledgers.middleware.api.domain.sca.SCAConsentResponseTO;
import de.adorsys.ledgers.middleware.api.domain.um.AisConsentTO;
import de.adorsys.ledgers.middleware.api.exception.AisConsentNotFoundMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.InsufficientPermissionMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.PaymentNotFoundMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.SCAMethodNotSupportedMiddleException;
import de.adorsys.ledgers.middleware.api.exception.SCAOperationExpiredMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.SCAOperationNotFoundMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.SCAOperationUsedOrStolenMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.SCAOperationValidationMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.UserScaDataNotFoundMiddlewareException;
import de.adorsys.ledgers.middleware.api.service.MiddlewareAccountManagementService;
import de.adorsys.ledgers.middleware.rest.annotation.MiddlewareUserResource;
import de.adorsys.ledgers.middleware.rest.exception.ConflictRestException;
import de.adorsys.ledgers.middleware.rest.exception.ForbiddenRestException;
import de.adorsys.ledgers.middleware.rest.exception.GoneRestException;
import de.adorsys.ledgers.middleware.rest.exception.NotAcceptableRestException;
import de.adorsys.ledgers.middleware.rest.exception.NotFoundRestException;
import de.adorsys.ledgers.middleware.rest.exception.ValidationRestException;
import de.adorsys.ledgers.middleware.rest.resource.ConsentRestAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/accounts"})
@MiddlewareUserResource
public class ConsentResource
implements ConsentRestAPI {
    private static final Logger logger = LoggerFactory.getLogger(ConsentResource.class);
    private final MiddlewareAccountManagementService middlewareAccountService;

    public ConsentResource(MiddlewareAccountManagementService middlewareAccountService) {
        this.middlewareAccountService = middlewareAccountService;
    }

    public ResponseEntity<SCAConsentResponseTO> startSCA(String consentId, AisConsentTO aisConsent) {
        try {
            return ResponseEntity.ok((Object)this.middlewareAccountService.startSCA(consentId, aisConsent));
        }
        catch (InsufficientPermissionMiddlewareException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ForbiddenRestException(e.getMessage()).withDevMessage(e.getMessage());
        }
    }

    public ResponseEntity<SCAConsentResponseTO> getSCA(String consentId, String authorisationId) throws ConflictRestException {
        try {
            return ResponseEntity.ok((Object)this.middlewareAccountService.loadSCAForAisConsent(consentId, authorisationId));
        }
        catch (AisConsentNotFoundMiddlewareException | SCAOperationExpiredMiddlewareException e) {
            logger.error(e.getMessage(), e);
            throw new NotFoundRestException(e.getMessage());
        }
    }

    public ResponseEntity<SCAConsentResponseTO> selectMethod(String consentId, String authorisationId, String scaMethodId) throws ValidationRestException, ConflictRestException, NotFoundRestException {
        try {
            return ResponseEntity.ok((Object)this.middlewareAccountService.selectSCAMethodForAisConsent(consentId, authorisationId, scaMethodId));
        }
        catch (AisConsentNotFoundMiddlewareException | PaymentNotFoundMiddlewareException | SCAOperationNotFoundMiddlewareException | UserScaDataNotFoundMiddlewareException e) {
            logger.error(e.getMessage(), e);
            throw new NotFoundRestException(e.getMessage());
        }
        catch (SCAOperationValidationMiddlewareException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ValidationRestException(e.getMessage());
        }
        catch (SCAMethodNotSupportedMiddleException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new NotAcceptableRestException(e.getMessage());
        }
    }

    public ResponseEntity<SCAConsentResponseTO> authorizeConsent(String consentId, String authorisationId, String authCode) throws ValidationRestException, NotFoundRestException, GoneRestException {
        try {
            return ResponseEntity.ok((Object)this.middlewareAccountService.authorizeConsent(consentId, authorisationId, authCode));
        }
        catch (AisConsentNotFoundMiddlewareException | SCAOperationNotFoundMiddlewareException e) {
            logger.error(e.getMessage(), e);
            throw new NotFoundRestException(e.getMessage());
        }
        catch (SCAOperationValidationMiddlewareException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ValidationRestException(e.getMessage());
        }
        catch (SCAOperationUsedOrStolenMiddlewareException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new NotAcceptableRestException(e.getMessage());
        }
        catch (SCAOperationExpiredMiddlewareException e) {
            logger.error(e.getMessage());
            throw new GoneRestException(e.getMessage());
        }
    }
}

