/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.resource;

import de.adorsys.ledgers.middleware.api.domain.sca.SCALoginResponseTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserRoleTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.ledgers.middleware.api.exception.InsufficientPermissionMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.UserAlreadyExistsMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.UserNotFoundMiddlewareException;
import de.adorsys.ledgers.middleware.api.service.AppManagementService;
import de.adorsys.ledgers.middleware.api.service.MiddlewareOnlineBankingService;
import de.adorsys.ledgers.middleware.api.service.MiddlewareUserManagementService;
import de.adorsys.ledgers.middleware.rest.annotation.MiddlewareUserResource;
import de.adorsys.ledgers.middleware.rest.exception.ConflictRestException;
import de.adorsys.ledgers.middleware.rest.exception.RestException;
import de.adorsys.ledgers.middleware.rest.resource.AppMgmtRestAPI;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/management/app"})
@MiddlewareUserResource
public class AppMgmtResource
implements AppMgmtRestAPI {
    private static final Logger logger = LoggerFactory.getLogger(AppMgmtResource.class);
    @Autowired
    private AppManagementService appManagementService;
    @Autowired
    private MiddlewareUserManagementService userManagementService;
    @Autowired
    private MiddlewareOnlineBankingService middlewareUserService;

    public ResponseEntity<String> ping() {
        return ResponseEntity.ok((Object)"pong");
    }

    @PreAuthorize(value="hasRole('SYSTEM')")
    public ResponseEntity<Void> initApp() {
        try {
            this.appManagementService.initApp();
            return ResponseEntity.ok().build();
        }
        catch (IOException e) {
            throw new RestException("Error initializing deposit account module.", (Throwable)e);
        }
    }

    public ResponseEntity<BearerTokenTO> admin(@RequestBody(required=true) UserTO adminUser) {
        List users = this.userManagementService.listUsers(0, 1);
        if (!users.isEmpty()) {
            String ADMIN_FIRST = "Admin user can not be created after initialization. This must be the first user of the system.";
            logger.error("Admin user can not be created after initialization. This must be the first user of the system.");
            throw new ConflictRestException("Can not create admin user.").withDevMessage("Admin user can not be created after initialization. This must be the first user of the system.");
        }
        UserTO user = new UserTO();
        user.setLogin(adminUser.getLogin());
        user.setPin(adminUser.getPin());
        user.setEmail(adminUser.getEmail());
        user.getUserRoles().add(UserRoleTO.SYSTEM);
        try {
            this.userManagementService.create(user);
        }
        catch (UserAlreadyExistsMiddlewareException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ConflictRestException(e.getMessage()).withDevMessage(e.getMessage());
        }
        try {
            SCALoginResponseTO scaLoginResponseTO = this.middlewareUserService.authorise(adminUser.getLogin(), adminUser.getPin(), UserRoleTO.SYSTEM);
            return ResponseEntity.ok((Object)scaLoginResponseTO.getBearerToken());
        }
        catch (UserNotFoundMiddlewareException e) {
            String USER_NOT_FOUND_SHALL_NOT_HAPPEN = "Shall not happen. We just created admin user.";
            logger.error(USER_NOT_FOUND_SHALL_NOT_HAPPEN, (Throwable)e);
            throw new IllegalStateException(USER_NOT_FOUND_SHALL_NOT_HAPPEN, e);
        }
        catch (InsufficientPermissionMiddlewareException e) {
            String ISSUFICIENT_PERM_SHALL_NOT_HAPPEN = "Unknownd exception, shall not happen.";
            logger.error(ISSUFICIENT_PERM_SHALL_NOT_HAPPEN, (Throwable)e);
            throw new IllegalStateException(ISSUFICIENT_PERM_SHALL_NOT_HAPPEN, e);
        }
    }
}

