/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.resource;

import de.adorsys.ledgers.middleware.api.domain.account.AccountBalanceTO;
import de.adorsys.ledgers.middleware.api.domain.account.AccountDetailsTO;
import de.adorsys.ledgers.middleware.api.domain.account.FundsConfirmationRequestTO;
import de.adorsys.ledgers.middleware.api.domain.account.TransactionTO;
import de.adorsys.ledgers.middleware.api.domain.payment.AmountTO;
import de.adorsys.ledgers.middleware.api.exception.AccountNotFoundMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.AccountWithPrefixGoneMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.AccountWithSuffixExistsMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.InsufficientPermissionMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.TransactionNotFoundMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.UserNotFoundMiddlewareException;
import de.adorsys.ledgers.middleware.api.service.MiddlewareAccountManagementService;
import de.adorsys.ledgers.middleware.rest.annotation.MiddlewareUserResource;
import de.adorsys.ledgers.middleware.rest.exception.ConflictRestException;
import de.adorsys.ledgers.middleware.rest.exception.ForbiddenRestException;
import de.adorsys.ledgers.middleware.rest.exception.NotFoundRestException;
import de.adorsys.ledgers.middleware.rest.exception.RestException;
import de.adorsys.ledgers.middleware.rest.resource.AccountRestAPI;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/accounts"})
@MiddlewareUserResource
public class AccountResource
implements AccountRestAPI {
    private static final Logger logger = LoggerFactory.getLogger(AccountResource.class);
    private final MiddlewareAccountManagementService middlewareAccountService;

    public AccountResource(MiddlewareAccountManagementService middlewareAccountService) {
        this.middlewareAccountService = middlewareAccountService;
    }

    @PreAuthorize(value="hasRole('CUSTOMER')")
    public ResponseEntity<List<AccountDetailsTO>> getListOfAccounts() {
        return ResponseEntity.ok((Object)this.middlewareAccountService.listOfDepositAccounts());
    }

    @PreAuthorize(value="hasRole('CUSTOMER') and tokenUsage('DIRECT_ACCESS')")
    public ResponseEntity<Void> createDepositAccount(AccountDetailsTO accountDetailsTO) {
        String iban = accountDetailsTO.getIban();
        String accountNumberPrefix = StringUtils.substring((String)iban, (int)0, (int)(iban.length() - 2));
        String accountNumberSuffix = StringUtils.substringAfter((String)iban, (String)accountNumberPrefix);
        try {
            this.middlewareAccountService.createDepositAccount(accountNumberPrefix, accountNumberSuffix, accountDetailsTO);
            return ResponseEntity.ok().build();
        }
        catch (AccountWithPrefixGoneMiddlewareException | AccountWithSuffixExistsMiddlewareException | UserNotFoundMiddlewareException e) {
            logger.error(e.getMessage(), e);
            throw new ConflictRestException(e.getMessage()).withDevMessage(e.getMessage());
        }
    }

    @PreAuthorize(value="accountInfoById(#accountId)")
    public ResponseEntity<AccountDetailsTO> getAccountDetailsById(String accountId) {
        try {
            return ResponseEntity.ok((Object)this.middlewareAccountService.getDepositAccountById(accountId, LocalDateTime.now(), true));
        }
        catch (AccountNotFoundMiddlewareException e) {
            throw this.notFoundRestException(e);
        }
        catch (InsufficientPermissionMiddlewareException e) {
            throw this.forbiddenRestException(e);
        }
    }

    @PreAuthorize(value="accountInfoById(#accountId)")
    public ResponseEntity<List<AccountBalanceTO>> getBalances(String accountId) {
        try {
            AccountDetailsTO accountDetails = this.middlewareAccountService.getDepositAccountById(accountId, LocalDateTime.now(), true);
            return ResponseEntity.ok((Object)accountDetails.getBalances());
        }
        catch (AccountNotFoundMiddlewareException e) {
            throw this.notFoundRestException(e);
        }
        catch (InsufficientPermissionMiddlewareException e) {
            throw this.forbiddenRestException(e);
        }
    }

    @PreAuthorize(value="accountInfoById(#accountId)")
    public ResponseEntity<List<TransactionTO>> getTransactionByDates(String accountId, LocalDate dateFrom, LocalDate dateTo) {
        this.dateChecker(dateFrom, dateTo);
        try {
            List transactions = this.middlewareAccountService.getTransactionsByDates(accountId, this.validDate(dateFrom), this.validDate(dateTo));
            return ResponseEntity.ok((Object)transactions);
        }
        catch (AccountNotFoundMiddlewareException e) {
            throw this.notFoundRestException(e);
        }
        catch (InsufficientPermissionMiddlewareException e) {
            throw this.forbiddenRestException(e);
        }
    }

    @PreAuthorize(value="accountInfoById(#accountId)")
    public ResponseEntity<TransactionTO> getTransactionById(String accountId, String transactionId) {
        try {
            return ResponseEntity.ok((Object)this.middlewareAccountService.getTransactionById(accountId, transactionId));
        }
        catch (AccountNotFoundMiddlewareException | TransactionNotFoundMiddlewareException e) {
            logger.error(e.getMessage(), e);
            throw new NotFoundRestException(e.getMessage()).withDevMessage(e.getMessage());
        }
        catch (InsufficientPermissionMiddlewareException e) {
            throw this.forbiddenRestException(e);
        }
    }

    @PreAuthorize(value="accountInfoByIban(#iban)")
    public ResponseEntity<AccountDetailsTO> getAccountDetailsByIban(String iban) {
        try {
            return ResponseEntity.ok((Object)this.middlewareAccountService.getDepositAccountByIban(iban, LocalDateTime.now(), true));
        }
        catch (AccountNotFoundMiddlewareException e) {
            throw this.notFoundRestException(e);
        }
        catch (InsufficientPermissionMiddlewareException e) {
            throw this.forbiddenRestException(e);
        }
    }

    @PreAuthorize(value="accountInfoByIban(#request.psuAccount.iban)")
    public ResponseEntity<Boolean> fundsConfirmation(FundsConfirmationRequestTO request) {
        try {
            boolean fundsAvailable = this.middlewareAccountService.confirmFundsAvailability(request);
            return ResponseEntity.ok((Object)fundsAvailable);
        }
        catch (AccountNotFoundMiddlewareException e) {
            throw this.notFoundRestException(e);
        }
    }

    private void dateChecker(LocalDate dateFrom, LocalDate dateTo) {
        if (!this.validDate(dateFrom).isEqual(this.validDate(dateTo)) && this.validDate(dateFrom).isAfter(this.validDate(dateTo))) {
            throw new ConflictRestException("Illegal request dates sequence, possibly swapped 'date from' with 'date to'");
        }
    }

    private LocalDate validDate(LocalDate date) {
        return Optional.ofNullable(date).orElseGet(LocalDate::now);
    }

    private RestException forbiddenRestException(InsufficientPermissionMiddlewareException e) {
        logger.error(e.getMessage(), (Throwable)e);
        return new ForbiddenRestException(e.getMessage()).withDevMessage(e.getMessage());
    }

    private RestException notFoundRestException(AccountNotFoundMiddlewareException e) {
        logger.error(e.getMessage(), (Throwable)e);
        return new NotFoundRestException(e.getMessage()).withDevMessage(e.getMessage());
    }

    @PreAuthorize(value="hasRole('TECHNICAL')")
    public ResponseEntity<Void> depositCash(String accountId, AmountTO amount) {
        try {
            this.middlewareAccountService.depositCash(accountId, amount);
            return ResponseEntity.accepted().build();
        }
        catch (AccountNotFoundMiddlewareException e) {
            throw this.notFoundRestException(e);
        }
    }
}

