/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.client.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiPartContentUtils {
    private static final Logger log = LoggerFactory.getLogger(MultiPartContentUtils.class);
    private static final Pattern BOUNDARY_PATTERN = Pattern.compile("^(--\\w+)[\\r\\n]*((?s).*)");

    private MultiPartContentUtils() {
    }

    public static MultiPartContent parse(String content) {
        String boundary = MultiPartContentUtils.getBoundary(content);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{boundary})) {
            return new MultiPartContent(MultiPartContentUtils.getXmlSctPart(content, boundary), MultiPartContentUtils.getJsonStandingOrderType(content, boundary));
        }
        log.error("Boundary is absent in multi-part content: {}", (Object)content);
        return new MultiPartContent();
    }

    private static String getJsonStandingOrderType(String content, String boundary) {
        return MultiPartContentUtils.getPartByTypeAndStartText(content, boundary, "application/json", "{");
    }

    private static String getXmlSctPart(String content, String boundary) {
        return MultiPartContentUtils.getPartByTypeAndStartText(content, boundary, "application/xml", "<Document");
    }

    private static String getPartByTypeAndStartText(String content, String boundary, String mediaType, String startText) {
        String[] parts;
        if (boundary != null && (parts = content.split(boundary)).length >= 2) {
            for (String part : parts) {
                if (!part.contains(mediaType)) continue;
                return part.substring(part.indexOf(startText)).trim();
            }
        }
        return null;
    }

    private static String getBoundary(String content) {
        Matcher matcher = BOUNDARY_PATTERN.matcher(content);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static class MultiPartContent {
        private String xmlSct;
        private String jsonStandingOrderType;

        public String getXmlSct() {
            return this.xmlSct;
        }

        public String getJsonStandingOrderType() {
            return this.jsonStandingOrderType;
        }

        public void setXmlSct(String xmlSct) {
            this.xmlSct = xmlSct;
        }

        public void setJsonStandingOrderType(String jsonStandingOrderType) {
            this.jsonStandingOrderType = jsonStandingOrderType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MultiPartContent)) {
                return false;
            }
            MultiPartContent other = (MultiPartContent)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$xmlSct = this.getXmlSct();
            String other$xmlSct = other.getXmlSct();
            if (this$xmlSct == null ? other$xmlSct != null : !this$xmlSct.equals(other$xmlSct)) {
                return false;
            }
            String this$jsonStandingOrderType = this.getJsonStandingOrderType();
            String other$jsonStandingOrderType = other.getJsonStandingOrderType();
            return !(this$jsonStandingOrderType == null ? other$jsonStandingOrderType != null : !this$jsonStandingOrderType.equals(other$jsonStandingOrderType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MultiPartContent;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $xmlSct = this.getXmlSct();
            result = result * 59 + ($xmlSct == null ? 43 : $xmlSct.hashCode());
            String $jsonStandingOrderType = this.getJsonStandingOrderType();
            result = result * 59 + ($jsonStandingOrderType == null ? 43 : $jsonStandingOrderType.hashCode());
            return result;
        }

        public String toString() {
            return "MultiPartContentUtils.MultiPartContent(xmlSct=" + this.getXmlSct() + ", jsonStandingOrderType=" + this.getJsonStandingOrderType() + ")";
        }

        public MultiPartContent() {
        }

        public MultiPartContent(String xmlSct, String jsonStandingOrderType) {
            this.xmlSct = xmlSct;
            this.jsonStandingOrderType = jsonStandingOrderType;
        }
    }
}

