/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.client.mappers;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import de.adorsys.ledgers.middleware.client.mappers.PaymentMapperTO;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

@Configuration
public class PaymentMapperConfiguration {
    private static final Logger log = LoggerFactory.getLogger(PaymentMapperConfiguration.class);
    private static final String CLASSPATH_PREFIX = "classpath:";
    private static final String DEFAULT_PAYMENT_HOLDER = "classpath:payment_mapping.yml";
    private static final ResourceLoader resourceLoader = new DefaultResourceLoader();
    private final ObjectMapper objectMapper;
    @Value(value="${ledgers.payment_mapping.path:}")
    private String paymentMapping;

    @Bean
    public PaymentMapperTO paymentMapperTO() throws IOException {
        try {
            Resource resource = resourceLoader.getResource(this.resolveYmlToRead());
            ObjectMapper yamlMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
            PaymentMapperTO mapperTO = (PaymentMapperTO)yamlMapper.readValue(resource.getInputStream(), PaymentMapperTO.class);
            mapperTO.setMapper(this.objectMapper);
            return mapperTO;
        }
        catch (IOException e) {
            log.error("Could not process payment mapper configuration!");
            throw e;
        }
    }

    private String resolveYmlToRead() {
        return StringUtils.isBlank((CharSequence)this.paymentMapping) ? DEFAULT_PAYMENT_HOLDER : CLASSPATH_PREFIX + this.paymentMapping;
    }

    public PaymentMapperConfiguration(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

