/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.client.mappers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import de.adorsys.ledgers.middleware.api.domain.account.AccountReferenceTO;
import de.adorsys.ledgers.middleware.api.domain.general.AddressTO;
import de.adorsys.ledgers.middleware.api.domain.payment.AmountTO;
import de.adorsys.ledgers.middleware.api.domain.payment.ChargeBearerTO;
import de.adorsys.ledgers.middleware.api.domain.payment.FrequencyCodeTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTargetTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTypeTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PurposeCodeTO;
import de.adorsys.ledgers.middleware.api.domain.payment.RemittanceInformationStructuredTO;
import de.adorsys.ledgers.middleware.api.domain.payment.TransactionStatusTO;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Currency;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.json.JSONObject;
import org.json.XML;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaymentMapperTO {
    private static final Logger log = LoggerFactory.getLogger(PaymentMapperTO.class);
    private Map<String, List<String>> debtorPart;
    private Map<String, List<String>> creditorPart;
    private Map<String, List<String>> address;
    private Map<String, List<String>> reference;
    private Map<String, List<String>> amount;
    @JsonIgnore
    private ObjectMapper mapper;
    @JsonIgnore
    private XmlMapper xmlMapper = new XmlMapper();

    @JsonIgnore
    public PaymentTO toAbstractPayment(String payment, String paymentType, String paymentProduct) {
        JsonNode node = this.readTree(payment, paymentProduct);
        PaymentTO paymentTO = this.parseDebtorPart(paymentType, paymentProduct, node);
        List<PaymentTargetTO> parts = this.parseCreditorParts(node, paymentTO.getPaymentType());
        paymentTO.setTargets(parts);
        return paymentTO;
    }

    private JsonNode readTree(String payment, String product) {
        try {
            if (product.contains("pain") || product.contains("xml")) {
                JSONObject json = XML.toJSONObject((String)payment);
                return this.mapper.readTree(json.toString());
            }
            return this.mapper.readTree(payment);
        }
        catch (IOException e) {
            log.error("Read tree exception {}, {}", (Object)e.getCause(), (Object)e.getMessage());
            throw new IllegalArgumentException("Could not parse payment!");
        }
    }

    private List<PaymentTargetTO> parseCreditorParts(JsonNode node, PaymentTypeTO type) {
        ArrayList<PaymentTargetTO> targets = new ArrayList<PaymentTargetTO>();
        List<JsonNode> nodes = this.debtorPart.get("targets").stream().map(arg_0 -> ((JsonNode)node).findValue(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        if (type == PaymentTypeTO.BULK) {
            nodes.forEach(n -> n.elements().forEachRemaining(t -> targets.add(this.mapTarget((JsonNode)t))));
        } else if (!nodes.isEmpty()) {
            nodes.forEach(t -> targets.add(this.mapTarget((JsonNode)t)));
        } else {
            targets.add(this.mapTarget(node));
        }
        return targets;
    }

    private PaymentTO parseDebtorPart(String paymentType, String paymentProduct, JsonNode node) {
        PaymentTO paymentTO = new PaymentTO();
        paymentTO.setPaymentProduct(paymentProduct);
        paymentTO.setPaymentType(PaymentTypeTO.valueOf((String)paymentType));
        this.mapProperties(this.debtorPart, "paymentId", node, arg_0 -> ((PaymentTO)paymentTO).setPaymentId(arg_0), String.class);
        this.mapProperties(this.debtorPart, "batchBookingPreferred", node, arg_0 -> ((PaymentTO)paymentTO).setBatchBookingPreferred(arg_0), Boolean.TYPE);
        this.mapProperties(this.debtorPart, "requestedExecutionDate", node, arg_0 -> ((PaymentTO)paymentTO).setRequestedExecutionDate(arg_0), LocalDate.class);
        this.mapProperties(this.debtorPart, "requestedExecutionTime", node, arg_0 -> ((PaymentTO)paymentTO).setRequestedExecutionTime(arg_0), LocalTime.class);
        this.mapProperties(this.debtorPart, "startDate", node, arg_0 -> ((PaymentTO)paymentTO).setStartDate(arg_0), LocalDate.class);
        this.mapProperties(this.debtorPart, "endDate", node, arg_0 -> ((PaymentTO)paymentTO).setEndDate(arg_0), LocalDate.class);
        this.mapProperties(this.debtorPart, "executionRule", node, arg_0 -> ((PaymentTO)paymentTO).setExecutionRule(arg_0), String.class);
        this.debtorPart.get("frequency").stream().map(arg_0 -> ((JsonNode)node).findValue(arg_0)).filter(Objects::nonNull).findFirst().map(JsonNode::asText).map(String::toUpperCase).map(FrequencyCodeTO::valueOf).ifPresent(arg_0 -> ((PaymentTO)paymentTO).setFrequency(arg_0));
        this.mapProperties(this.debtorPart, "dayOfExecution", node, arg_0 -> ((PaymentTO)paymentTO).setDayOfExecution(arg_0), Integer.class);
        this.mapProperties(this.debtorPart, "debtorAgent", node, arg_0 -> ((PaymentTO)paymentTO).setDebtorAgent(arg_0), String.class);
        this.mapProperties(this.debtorPart, "debtorName", node, arg_0 -> ((PaymentTO)paymentTO).setDebtorName(arg_0), String.class);
        this.mapProperties(this.debtorPart, "transactionStatus", node, arg_0 -> ((PaymentTO)paymentTO).setTransactionStatus(arg_0), TransactionStatusTO.class);
        this.fillEmbeddedProperty(this.debtorPart, "debtorAccount", node, this::mapReference, arg_0 -> ((PaymentTO)paymentTO).setDebtorAccount(arg_0));
        return paymentTO;
    }

    private PaymentTargetTO mapTarget(JsonNode node) {
        PaymentTargetTO target = new PaymentTargetTO();
        this.mapProperties(this.creditorPart, "endToEndIdentification", node, arg_0 -> ((PaymentTargetTO)target).setEndToEndIdentification(arg_0), String.class);
        this.mapProperties(this.creditorPart, "currencyOfTransfer", node, arg_0 -> ((PaymentTargetTO)target).setCurrencyOfTransfer(arg_0), Currency.class);
        this.mapProperties(this.creditorPart, "creditorAgent", node, arg_0 -> ((PaymentTargetTO)target).setCreditorAgent(arg_0), String.class);
        this.mapProperties(this.creditorPart, "creditorName", node, arg_0 -> ((PaymentTargetTO)target).setCreditorName(arg_0), String.class);
        this.mapProperties(this.creditorPart, "purposeCode", node, arg_0 -> ((PaymentTargetTO)target).setPurposeCode(arg_0), PurposeCodeTO.class);
        this.mapProperties(this.creditorPart, "remittanceInformationUnstructured", node, arg_0 -> ((PaymentTargetTO)target).setRemittanceInformationUnstructured(arg_0), String.class);
        this.mapProperties(this.creditorPart, "remittanceInformationStructured", node, arg_0 -> ((PaymentTargetTO)target).setRemittanceInformationStructured(arg_0), RemittanceInformationStructuredTO.class);
        this.mapProperties(this.creditorPart, "chargeBearer", node, arg_0 -> ((PaymentTargetTO)target).setChargeBearerTO(arg_0), ChargeBearerTO.class);
        this.fillEmbeddedProperty(this.creditorPart, "creditorAccount", node, this::mapReference, arg_0 -> ((PaymentTargetTO)target).setCreditorAccount(arg_0));
        this.fillEmbeddedProperty(this.creditorPart, "instructedAmount", node, this::mapAmount, arg_0 -> ((PaymentTargetTO)target).setInstructedAmount(arg_0));
        this.fillEmbeddedProperty(this.creditorPart, "creditorAddress", node, this::mapAddress, arg_0 -> ((PaymentTargetTO)target).setCreditorAddress(arg_0));
        return target;
    }

    private AccountReferenceTO mapReference(JsonNode node) {
        AccountReferenceTO account = new AccountReferenceTO();
        this.mapProperties(this.reference, "iban", node, arg_0 -> ((AccountReferenceTO)account).setIban(arg_0), String.class);
        this.mapProperties(this.reference, "currency", node, arg_0 -> ((AccountReferenceTO)account).setCurrency(arg_0), Currency.class);
        return account;
    }

    private AddressTO mapAddress(JsonNode node) {
        AddressTO addressTO = new AddressTO();
        this.mapProperties(this.address, "street", node, arg_0 -> ((AddressTO)addressTO).setStreet(arg_0), String.class);
        this.mapProperties(this.address, "buildingNumber", node, arg_0 -> ((AddressTO)addressTO).setBuildingNumber(arg_0), String.class);
        this.mapProperties(this.address, "city", node, arg_0 -> ((AddressTO)addressTO).setCity(arg_0), String.class);
        this.mapProperties(this.address, "postalCode", node, arg_0 -> ((AddressTO)addressTO).setPostalCode(arg_0), String.class);
        this.mapProperties(this.address, "country", node, arg_0 -> ((AddressTO)addressTO).setCountry(arg_0), String.class);
        this.mapProperties(this.address, "line1", node, arg_0 -> ((AddressTO)addressTO).setLine1(arg_0), String.class);
        this.mapProperties(this.address, "line2", node, arg_0 -> ((AddressTO)addressTO).setLine2(arg_0), String.class);
        return addressTO;
    }

    private AmountTO mapAmount(JsonNode node) {
        AmountTO instructedAmount = new AmountTO();
        this.mapProperties(this.amount, "amount", node, arg_0 -> ((AmountTO)instructedAmount).setAmount(arg_0), BigDecimal.class);
        this.mapProperties(this.amount, "currency", node, arg_0 -> ((AmountTO)instructedAmount).setCurrency(arg_0), Currency.class);
        return instructedAmount;
    }

    private <T> void fillEmbeddedProperty(Map<String, List<String>> map, String property, JsonNode node, Function<JsonNode, T> mappingMethod, Consumer<T> consumer) {
        Optional.ofNullable(map.get(property)).ifPresent(props -> this.mapEmbeddedProperty(node, mappingMethod, consumer, (List<String>)props));
    }

    private <T> void mapEmbeddedProperty(JsonNode node, Function<JsonNode, T> mappingMethod, Consumer<T> consumer, List<String> properties) {
        properties.stream().map(arg_0 -> ((JsonNode)node).findValue(arg_0)).filter(Objects::nonNull).map(mappingMethod).forEach(consumer);
    }

    private <T> void mapProperties(Map<String, List<String>> map, String property, JsonNode node, Consumer<T> consumer, Class<T> clazz) {
        Optional.ofNullable(map.get(property)).ifPresent(pr -> pr.forEach(p -> this.mapProperty(node, consumer, clazz, (String)p)));
    }

    private <T> void mapProperty(JsonNode node, Consumer<T> consumer, Class<T> clazz, String property) {
        Optional.ofNullable(node.findValue(property)).map(n -> this.mapObject((JsonNode)n, clazz)).ifPresent(consumer);
    }

    private <T> T mapObject(JsonNode node, Class<T> clazz) {
        try {
            while (node.fields().hasNext()) {
                node = (JsonNode)((Map.Entry)node.fields().next()).getValue();
            }
            return (T)this.mapper.readValue(node.toString(), clazz);
        }
        catch (IOException e) {
            log.error("Parse value exception {}", (Object)e.getMessage());
            return null;
        }
    }

    public Map<String, List<String>> getDebtorPart() {
        return this.debtorPart;
    }

    public Map<String, List<String>> getCreditorPart() {
        return this.creditorPart;
    }

    public Map<String, List<String>> getAddress() {
        return this.address;
    }

    public Map<String, List<String>> getReference() {
        return this.reference;
    }

    public Map<String, List<String>> getAmount() {
        return this.amount;
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public XmlMapper getXmlMapper() {
        return this.xmlMapper;
    }

    public void setDebtorPart(Map<String, List<String>> debtorPart) {
        this.debtorPart = debtorPart;
    }

    public void setCreditorPart(Map<String, List<String>> creditorPart) {
        this.creditorPart = creditorPart;
    }

    public void setAddress(Map<String, List<String>> address) {
        this.address = address;
    }

    public void setReference(Map<String, List<String>> reference) {
        this.reference = reference;
    }

    public void setAmount(Map<String, List<String>> amount) {
        this.amount = amount;
    }

    public void setMapper(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public void setXmlMapper(XmlMapper xmlMapper) {
        this.xmlMapper = xmlMapper;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaymentMapperTO)) {
            return false;
        }
        PaymentMapperTO other = (PaymentMapperTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, List<String>> this$debtorPart = this.getDebtorPart();
        Map<String, List<String>> other$debtorPart = other.getDebtorPart();
        if (this$debtorPart == null ? other$debtorPart != null : !((Object)this$debtorPart).equals(other$debtorPart)) {
            return false;
        }
        Map<String, List<String>> this$creditorPart = this.getCreditorPart();
        Map<String, List<String>> other$creditorPart = other.getCreditorPart();
        if (this$creditorPart == null ? other$creditorPart != null : !((Object)this$creditorPart).equals(other$creditorPart)) {
            return false;
        }
        Map<String, List<String>> this$address = this.getAddress();
        Map<String, List<String>> other$address = other.getAddress();
        if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
            return false;
        }
        Map<String, List<String>> this$reference = this.getReference();
        Map<String, List<String>> other$reference = other.getReference();
        if (this$reference == null ? other$reference != null : !((Object)this$reference).equals(other$reference)) {
            return false;
        }
        Map<String, List<String>> this$amount = this.getAmount();
        Map<String, List<String>> other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        ObjectMapper this$mapper = this.getMapper();
        ObjectMapper other$mapper = other.getMapper();
        if (this$mapper == null ? other$mapper != null : !this$mapper.equals(other$mapper)) {
            return false;
        }
        XmlMapper this$xmlMapper = this.getXmlMapper();
        XmlMapper other$xmlMapper = other.getXmlMapper();
        return !(this$xmlMapper == null ? other$xmlMapper != null : !this$xmlMapper.equals(other$xmlMapper));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PaymentMapperTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, List<String>> $debtorPart = this.getDebtorPart();
        result = result * 59 + ($debtorPart == null ? 43 : ((Object)$debtorPart).hashCode());
        Map<String, List<String>> $creditorPart = this.getCreditorPart();
        result = result * 59 + ($creditorPart == null ? 43 : ((Object)$creditorPart).hashCode());
        Map<String, List<String>> $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
        Map<String, List<String>> $reference = this.getReference();
        result = result * 59 + ($reference == null ? 43 : ((Object)$reference).hashCode());
        Map<String, List<String>> $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        ObjectMapper $mapper = this.getMapper();
        result = result * 59 + ($mapper == null ? 43 : $mapper.hashCode());
        XmlMapper $xmlMapper = this.getXmlMapper();
        result = result * 59 + ($xmlMapper == null ? 43 : $xmlMapper.hashCode());
        return result;
    }

    public String toString() {
        return "PaymentMapperTO(debtorPart=" + this.getDebtorPart() + ", creditorPart=" + this.getCreditorPart() + ", address=" + this.getAddress() + ", reference=" + this.getReference() + ", amount=" + this.getAmount() + ", mapper=" + this.getMapper() + ", xmlMapper=" + this.getXmlMapper() + ")";
    }

    public PaymentMapperTO() {
    }

    public PaymentMapperTO(Map<String, List<String>> debtorPart, Map<String, List<String>> creditorPart, Map<String, List<String>> address, Map<String, List<String>> reference, Map<String, List<String>> amount, ObjectMapper mapper, XmlMapper xmlMapper) {
        this.debtorPart = debtorPart;
        this.creditorPart = creditorPart;
        this.address = address;
        this.reference = reference;
        this.amount = amount;
        this.mapper = mapper;
        this.xmlMapper = xmlMapper;
    }
}

