/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.resource;

import de.adorsys.ledgers.middleware.api.domain.sca.GlobalScaResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.StartScaOprTO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Tag(name="LDG007 - Redirect SCA", description="Provide an API to preform SCA process for any kind of banking operation")
public interface RedirectScaRestAPI {
    public static final String BASE_PATH = "/sca";

    @PostMapping(value={"/start"})
    @Operation(summary="Start SCA")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey", scopes={"sca", "full_access"}), @SecurityRequirement(name="oAuth2", scopes={"sca", "full_access"})})
    public ResponseEntity<GlobalScaResponseTO> startSca(@RequestBody StartScaOprTO var1);

    @GetMapping(value={"/authorisations/{authorisationId}"})
    @Operation(summary="Get SCA", description="Get the authorization response object eventually containing the list of selected sca methods.")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey", scopes={"sca", "full_access"}), @SecurityRequirement(name="oAuth2", scopes={"sca", "full_access"})})
    public ResponseEntity<GlobalScaResponseTO> getSCA(@PathVariable(value="authorisationId") String var1);

    @PutMapping(value={"/authorisations/{authorisationId}/scaMethods/{scaMethodId}"})
    @Operation(summary="Select SCA Method", description="Select teh given sca method and request for authentication code generation.")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey", scopes={"sca", "full_access"}), @SecurityRequirement(name="oAuth2", scopes={"sca", "full_access"})})
    public ResponseEntity<GlobalScaResponseTO> selectMethod(@PathVariable(value="authorisationId") String var1, @PathVariable(value="scaMethodId") String var2);

    @PutMapping(value={"/authorisations/{authorisationId}/authCode"})
    @Operation(summary="Validate authorization code", description="Validate an authentication code and returns the token")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey", scopes={"sca", "full_access"}), @SecurityRequirement(name="oAuth2", scopes={"sca", "full_access"})})
    public ResponseEntity<GlobalScaResponseTO> validateScaCode(@PathVariable(value="authorisationId") String var1, @RequestParam(name="authCode") String var2);
}

