/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.rest.resource;

import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTypeTO;
import de.adorsys.ledgers.middleware.api.domain.sca.GlobalScaResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.OpTypeTO;
import de.adorsys.ledgers.middleware.api.domain.um.AisConsentTO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Tag(name="LDGXXX - Payment", description="Provide endpoints for operation initiation")
public interface OperationInitiationRestApi {
    public static final String BASE_PATH = "/operation";

    @PostMapping(value={"/payment"}, params={"paymentType"})
    @Operation(summary="Initiates a Payment", description="Initiates a payment")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    public ResponseEntity<GlobalScaResponseTO> initiatePayment(@RequestParam(value="paymentType") PaymentTypeTO var1, @RequestBody PaymentTO var2);

    @PostMapping(value={"/cancellation/{opId}"})
    @Operation(summary="Initiates a Payment Cancellation", description="Initiates a Payment Cancellation")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    public ResponseEntity<GlobalScaResponseTO> initiatePmtCancellation(@PathVariable(value="opId") String var1);

    @PostMapping(value={"/consent"})
    @Operation(summary="Initiate AIS consent", description="Validates AIS consent and stores it for future usage")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    public ResponseEntity<GlobalScaResponseTO> initiateAisConsent(@RequestBody AisConsentTO var1);

    @PostMapping(value={"/{opType}/{opId}/execution"})
    @Operation(summary="Executes a Payment", description="Confirms payment execution")
    @SecurityRequirements(value={@SecurityRequirement(name="apiKey"), @SecurityRequirement(name="oAuth2")})
    public ResponseEntity<GlobalScaResponseTO> execution(@PathVariable(value="opType") OpTypeTO var1, @PathVariable(value="opId") String var2);
}

